/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8273.eui;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.RemoteModelWithStatus;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.eui.EuiGrid;
import ibm.nways.jdm.eui.EuiGridEvent;
import ibm.nways.jdm.eui.EuiGridListener;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.NumericInput;
import ibm.nways.jdm.eui.PropertySection;
import ibm.nways.jdm.eui.SingleChoiceInput;
import ibm.nways.jdm.eui.SingleChoiceInputRO;
import ibm.nways.jdm.eui.StringInput;
import ibm.nways.jdm.eui.StringInputRO;
import ibm.nways.jdm.eui.Table;
import ibm.nways.jdm.eui.TableColumn;
import ibm.nways.jdm.eui.TableColumns;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.TableStatus;
import ibm.nways.jdm8273.model.AtmxConnectionModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class AtmConnectionsBasePanel
extends DestinationPropBook {
    protected static ResourceBundle enumStrings = null;
    protected static ResourceBundle myResources = null;
    private static String title = "ATM Connections";
    protected boolean containsWritableField = false;
    protected boolean containsCreatableField = false;
    protected GenModel AtmxConnection_model;
    protected AtmVccSummarySection AtmVccSummaryPropertySection;
    protected AtmVccInfoSection AtmVccInfoPropertySection;
    protected AtmVccReqQosSection AtmVccReqQosPropertySection;
    protected AtmVccAccQosSection AtmVccAccQosPropertySection;
    protected AtmVccActQosSection AtmVccActQosPropertySection;
    protected ModelInfo AtmVccTableInfo;
    protected ModelInfo AtmxConnDetailsInfo;
    protected int AtmVccTableIndex;
    protected AtmVccTable AtmVccTableData;
    protected TableColumns AtmVccTableColumns;
    protected TableStatus AtmVccTableStatus;
    protected static TableColumn[] AtmVccTableCols = new TableColumn[]{new TableColumn("Index.Slot", "Slot", 3, true), new TableColumn("Index.Port", "Port", 3, true), new TableColumn("AtmxConnDetails.AtmxVccVpi", "VPI", 3, false), new TableColumn("Index.Vci", "VCI", 3, true), new TableColumn("AtmxConnDetails.AtmxVccOperStatus", "Oper Status", 16, false), new TableColumn("AtmxConnDetails.AtmxVccCircuitType", "Type", 16, false), new TableColumn("AtmxConnDetails.AtmxVccDescription", "Description", 5, false)};
    protected boolean errorsFound = false;

    private static void loadStatics() {
        try {
            if (enumStrings == null) {
                enumStrings = ResourceBundle.getBundle("ibm.nways.jdm8273.eui.EnumeratedResources");
            }
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.jdm8273.eui.AtmConnectionsBasePanelResources");
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unable to access translation resources for panel AtmConnectionsBase");
        }
    }

    public static String getTitle() {
        AtmConnectionsBasePanel.loadStatics();
        if (myResources != null) {
            title = AtmConnectionsBasePanel.getNLSString("AtmConnectionsBasePanelTitle");
        }
        return title;
    }

    private static ResourceBundle getEnumStrings() {
        if (enumStrings == null) {
            AtmConnectionsBasePanel.loadStatics();
        }
        return enumStrings;
    }

    public AtmConnectionsBasePanel() {
        AtmConnectionsBasePanel.loadStatics();
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public String getDestinationTitle() {
        return AtmConnectionsBasePanel.getTitle();
    }

    protected void getModels() {
        this.AtmxConnection_model = (GenModel)this.getModel();
    }

    public void addSections() {
        this.getModels();
        this.createTables();
        this.addAtmVccSummarySection();
        this.addAtmVccInfoSection();
        this.addAtmVccReqQosSection();
        this.addAtmVccAccQosSection();
        this.addAtmVccActQosSection();
        if (this.containsCreatableField) {
            this.addCreateButton();
        }
        if (this.containsWritableField) {
            this.addApplyButton();
        }
        this.addRefreshButton();
        this.addHelpButton();
        this.reset();
    }

    protected void addAtmVccSummarySection() {
        this.AtmVccSummaryPropertySection = new AtmVccSummarySection();
        this.AtmVccSummaryPropertySection.layoutSection();
        this.addSection(AtmConnectionsBasePanel.getNLSString("AtmVccSummarySectionTitle"), this.AtmVccSummaryPropertySection);
    }

    protected void addAtmVccInfoSection() {
        this.AtmVccInfoPropertySection = new AtmVccInfoSection();
        this.AtmVccInfoPropertySection.layoutSection();
        this.addSection(AtmConnectionsBasePanel.getNLSString("AtmVccInfoSectionTitle"), this.AtmVccInfoPropertySection);
    }

    protected void addAtmVccReqQosSection() {
        this.AtmVccReqQosPropertySection = new AtmVccReqQosSection();
        this.AtmVccReqQosPropertySection.layoutSection();
        this.addSection(AtmConnectionsBasePanel.getNLSString("AtmVccReqQosSectionTitle"), this.AtmVccReqQosPropertySection);
    }

    protected void addAtmVccAccQosSection() {
        this.AtmVccAccQosPropertySection = new AtmVccAccQosSection();
        this.AtmVccAccQosPropertySection.layoutSection();
        this.addSection(AtmConnectionsBasePanel.getNLSString("AtmVccAccQosSectionTitle"), this.AtmVccAccQosPropertySection);
    }

    protected void addAtmVccActQosSection() {
        this.AtmVccActQosPropertySection = new AtmVccActQosSection();
        this.AtmVccActQosPropertySection.layoutSection();
        this.addSection(AtmConnectionsBasePanel.getNLSString("AtmVccActQosSectionTitle"), this.AtmVccActQosPropertySection);
    }

    protected void panelRowChange() {
        if (this.AtmVccSummaryPropertySection != null) {
            this.AtmVccSummaryPropertySection.rowChange();
        }
        if (this.AtmVccInfoPropertySection != null) {
            this.AtmVccInfoPropertySection.rowChange();
        }
        if (this.AtmVccReqQosPropertySection != null) {
            this.AtmVccReqQosPropertySection.rowChange();
        }
        if (this.AtmVccAccQosPropertySection != null) {
            this.AtmVccAccQosPropertySection.rowChange();
        }
        if (this.AtmVccActQosPropertySection != null) {
            this.AtmVccActQosPropertySection.rowChange();
        }
    }

    public void filterAtmxConnDetailsInfos(Vector vector) {
    }

    public int getInitialAtmVccTableRow() {
        return 0;
    }

    public ModelInfo initialAtmVccTableRow() {
        ModelInfo modelInfo = null;
        if (this.getNavContext() instanceof NavigationContext) {
            modelInfo = NavInitialRow.getInitialRow(this.getNavContext(), true);
        }
        return modelInfo;
    }

    protected void displayMsg(String string) {
        if (this.getBrowser() != null) {
            this.getBrowser().displayMsg(string);
        }
    }

    protected static String getNLSString(String string) {
        if (myResources == null) {
            return string;
        }
        try {
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    protected String getOverride(String string, String string2) {
        String string3 = null;
        try {
            string3 = NavFieldOverride.getFieldOverride(this.getNavContext(), string);
        }
        catch (ClassCastException classCastException) {
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (NullPointerException nullPointerException) {}
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public void reset() {
        this.displayMsg(AtmConnectionsBasePanel.getNLSString("startResetMsg"));
        this.AtmVccTableData.invalidate();
        this.errorsFound = false;
        super.reset();
        if (!this.errorsFound) {
            this.displayMsg(AtmConnectionsBasePanel.getNLSString("endResetMsg"));
            return;
        }
        this.displayMsg(String.valueOf(AtmConnectionsBasePanel.getNLSString("endResetMsg")) + " " + AtmConnectionsBasePanel.getNLSString("noteErrorsMsg"));
    }

    public void apply() {
        this.AtmxConnDetailsInfo = new ModelInfo();
        this.AtmxConnDetailsInfo.add("Index.Slot", (Serializable)this.AtmVccTableData.getValueAt("Index.Slot", this.AtmVccTableIndex));
        this.AtmxConnDetailsInfo.add("Index.Port", (Serializable)this.AtmVccTableData.getValueAt("Index.Port", this.AtmVccTableIndex));
        this.AtmxConnDetailsInfo.add("Index.Vci", (Serializable)this.AtmVccTableData.getValueAt("Index.Vci", this.AtmVccTableIndex));
        this.errorsFound = false;
        this.displayMsg(AtmConnectionsBasePanel.getNLSString("startApplyMsg"));
        super.apply();
        if (!this.errorsFound) {
            this.AtmVccTableInfo = (ModelInfo)this.AtmVccTableData.elementAt(this.AtmVccTableIndex);
            this.AtmVccTableInfo = this.AtmVccTableData.setRow();
            this.AtmVccTableData.setElementAt(this.AtmVccTableInfo, this.AtmVccTableIndex);
            super.reset();
            if (!this.errorsFound) {
                this.displayMsg(AtmConnectionsBasePanel.getNLSString("endApplyMsg"));
                return;
            }
            this.displayMsg(String.valueOf(AtmConnectionsBasePanel.getNLSString("endApplyMsg")) + " " + AtmConnectionsBasePanel.getNLSString("noteErrorsMsg"));
            return;
        }
        this.displayMsg(AtmConnectionsBasePanel.getNLSString("abortApplyMsg"));
    }

    public void createTables() {
        this.AtmVccTableData = new AtmVccTable();
        this.AtmVccTableIndex = 0;
        this.AtmVccTableColumns = new TableColumns(AtmVccTableCols);
        if (this.AtmxConnection_model instanceof RemoteModelWithStatus) {
            try {
                this.AtmVccTableStatus = (TableStatus)this.AtmxConnection_model.getStatus();
                return;
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
                return;
            }
        }
    }

    public class AtmVccSummarySection
    extends PropertySection
    implements EuiGridListener {
        ModelInfo chunk;
        Component AtmVccTableField;
        Label AtmVccTableFieldLabel;
        boolean AtmVccTableFieldWritable = false;

        public AtmVccSummarySection() {
            AtmConnectionsBasePanel.this = AtmConnectionsBasePanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createAtmVccTableField() {
            EuiGrid euiGrid = new EuiGrid(AtmConnectionsBasePanel.this.AtmVccTableData, AtmConnectionsBasePanel.this.AtmVccTableColumns, false);
            euiGrid.addRows(5);
            euiGrid.addEuiGridListener(this);
            euiGrid.setInitialRow(AtmConnectionsBasePanel.this.initialAtmVccTableRow());
            this.addTable(AtmConnectionsBasePanel.getNLSString("AtmVccTableLabel"), euiGrid);
            return euiGrid;
        }

        public void layoutSection() {
            this.AtmVccTableField = this.createAtmVccTableField();
        }

        public void apply() {
            if (!this.validateSection()) {
                AtmConnectionsBasePanel.this.errorsFound = true;
            }
        }

        public void reset() {
            AtmConnectionsBasePanel.this.displayMsg(AtmConnectionsBasePanel.getNLSString("accessDataMsg"));
            AtmConnectionsBasePanel.this.displayMsg(AtmConnectionsBasePanel.getNLSString("startTableGetMsg"));
            ((EuiGrid)this.AtmVccTableField).refresh();
            AtmConnectionsBasePanel.this.displayMsg(AtmConnectionsBasePanel.getNLSString("endTableGetMsg"));
            AtmConnectionsBasePanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.doLayout();
        }

        public boolean validateSection() {
            return true;
        }

        public void onEuiGridEvent(EuiGridEvent euiGridEvent) {
            System.out.println("Event received in section");
            if (euiGridEvent.getType() == 2001) {
                try {
                    if (euiGridEvent.getSource() == this.AtmVccTableField) {
                        AtmConnectionsBasePanel.this.AtmVccTableIndex = euiGridEvent.getRow();
                    }
                    AtmConnectionsBasePanel.this.AtmVccTableIndex = euiGridEvent.getRow();
                    ((EuiGrid)this.AtmVccTableField).deselectAllRows();
                    AtmConnectionsBasePanel.this.panelRowChange();
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    EuiGrid euiGrid = (EuiGrid)euiGridEvent.getSource();
                    euiGrid.deleteAllRows();
                    if (euiGridEvent.getSource() == this.AtmVccTableField) {
                        AtmConnectionsBasePanel.this.AtmVccTableIndex = 0;
                    }
                    AtmConnectionsBasePanel.this.AtmVccSummaryPropertySection.reset();
                    AtmConnectionsBasePanel.this.AtmVccInfoPropertySection.reset();
                    AtmConnectionsBasePanel.this.AtmVccReqQosPropertySection.reset();
                    AtmConnectionsBasePanel.this.AtmVccAccQosPropertySection.reset();
                    AtmConnectionsBasePanel.this.AtmVccActQosPropertySection.reset();
                    return;
                }
            }
        }
    }

    public class AtmVccInfoSection
    extends PropertySection {
        ModelInfo chunk;
        Component atmxVccSlotField;
        Component atmxVccPortField;
        Component atmxVccVpiField;
        Component atmxVccVciField;
        Component atmxVccDescriptionField;
        Component atmxVccAdmStatusField;
        Component atmxVccCircuitTypeField;
        Component atmxVccConnTypeField;
        Component atmxVccOperStatusField;
        Component atmxVccUpTimeField;
        Component atmxVccDownTimeField;
        Component atmxVccTxMaxFrameSizeField;
        Component atmxVccRxMaxFrameSizeField;
        Label atmxVccSlotFieldLabel;
        Label atmxVccPortFieldLabel;
        Label atmxVccVpiFieldLabel;
        Label atmxVccVciFieldLabel;
        Label atmxVccDescriptionFieldLabel;
        Label atmxVccAdmStatusFieldLabel;
        Label atmxVccCircuitTypeFieldLabel;
        Label atmxVccConnTypeFieldLabel;
        Label atmxVccOperStatusFieldLabel;
        Label atmxVccUpTimeFieldLabel;
        Label atmxVccDownTimeFieldLabel;
        Label atmxVccTxMaxFrameSizeFieldLabel;
        Label atmxVccRxMaxFrameSizeFieldLabel;
        boolean atmxVccSlotFieldWritable = false;
        boolean atmxVccPortFieldWritable = false;
        boolean atmxVccVpiFieldWritable = false;
        boolean atmxVccVciFieldWritable = false;
        boolean atmxVccDescriptionFieldWritable = false;
        boolean atmxVccAdmStatusFieldWritable = false;
        boolean atmxVccCircuitTypeFieldWritable = false;
        boolean atmxVccConnTypeFieldWritable = false;
        boolean atmxVccOperStatusFieldWritable = false;
        boolean atmxVccUpTimeFieldWritable = false;
        boolean atmxVccDownTimeFieldWritable = false;
        boolean atmxVccTxMaxFrameSizeFieldWritable = false;
        boolean atmxVccRxMaxFrameSizeFieldWritable = false;

        public AtmVccInfoSection() {
            AtmConnectionsBasePanel.this = AtmConnectionsBasePanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createatmxVccSlotField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AtmxVccSlot.access", "read-only");
            this.atmxVccSlotFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.atmxVccSlotFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("atmxVccSlotLabel"), 2);
            if (this.atmxVccSlotFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(1, 9);
                this.addRow(this.atmxVccSlotFieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.atmxVccSlotFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getatmxVccSlotField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccSlotField);
            this.validateatmxVccSlotField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setatmxVccSlotField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.atmxVccSlotField);
                jDMInput.setValue(object);
                this.validateatmxVccSlotField();
            }
        }

        protected boolean validateatmxVccSlotField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccSlotField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.atmxVccSlotFieldLabel.setForeground(Color.yellow);
            } else {
                this.atmxVccSlotFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createatmxVccPortField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AtmxVccPort.access", "read-only");
            this.atmxVccPortFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.atmxVccPortFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("atmxVccPortLabel"), 2);
            if (this.atmxVccPortFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(1, 2);
                this.addRow(this.atmxVccPortFieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.atmxVccPortFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getatmxVccPortField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccPortField);
            this.validateatmxVccPortField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setatmxVccPortField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.atmxVccPortField);
                jDMInput.setValue(object);
                this.validateatmxVccPortField();
            }
        }

        protected boolean validateatmxVccPortField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccPortField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.atmxVccPortFieldLabel.setForeground(Color.yellow);
            } else {
                this.atmxVccPortFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createatmxVccVpiField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AtmxVccVpi.access", "read-only");
            this.atmxVccVpiFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.atmxVccVpiFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("atmxVccVpiLabel"), 2);
            if (this.atmxVccVpiFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 0);
                this.addRow(this.atmxVccVpiFieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.atmxVccVpiFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getatmxVccVpiField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccVpiField);
            this.validateatmxVccVpiField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setatmxVccVpiField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.atmxVccVpiField);
                jDMInput.setValue(object);
                this.validateatmxVccVpiField();
            }
        }

        protected boolean validateatmxVccVpiField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccVpiField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.atmxVccVpiFieldLabel.setForeground(Color.yellow);
            } else {
                this.atmxVccVpiFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createatmxVccVciField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AtmxVccVci.access", "read-only");
            this.atmxVccVciFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.atmxVccVciFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("atmxVccVciLabel"), 2);
            if (this.atmxVccVciFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(1, 1023);
                this.addRow(this.atmxVccVciFieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.atmxVccVciFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getatmxVccVciField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccVciField);
            this.validateatmxVccVciField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setatmxVccVciField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.atmxVccVciField);
                jDMInput.setValue(object);
                this.validateatmxVccVciField();
            }
        }

        protected boolean validateatmxVccVciField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccVciField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.atmxVccVciFieldLabel.setForeground(Color.yellow);
            } else {
                this.atmxVccVciFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createatmxVccDescriptionField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AtmxVccDescription.access", "read-write");
            String string2 = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AtmxVccDescription.length", "31");
            this.atmxVccDescriptionFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.atmxVccDescriptionFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("atmxVccDescriptionLabel"), 2);
            if (this.atmxVccDescriptionFieldWritable) {
                StringInput stringInput = new StringInput();
                stringInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.atmxVccDescriptionFieldLabel, (Component)stringInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return stringInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.atmxVccDescriptionFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getatmxVccDescriptionField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccDescriptionField);
            this.validateatmxVccDescriptionField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setatmxVccDescriptionField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.atmxVccDescriptionField);
                jDMInput.setValue(object);
                this.validateatmxVccDescriptionField();
            }
        }

        protected boolean validateatmxVccDescriptionField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccDescriptionField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.atmxVccDescriptionFieldLabel.setForeground(Color.yellow);
            } else {
                this.atmxVccDescriptionFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createatmxVccAdmStatusField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AtmxVccAdmStatus.access", "read-write");
            this.atmxVccAdmStatusFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.atmxVccAdmStatusFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("atmxVccAdmStatusLabel"), 2);
            if (this.atmxVccAdmStatusFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxConnectionModel.AtmxConnDetails.AtmxVccAdmStatusEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.AtmxVccAdmStatusEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
                this.addRow(this.atmxVccAdmStatusFieldLabel, (Component)singleChoiceInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxConnectionModel.AtmxConnDetails.AtmxVccAdmStatusEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.AtmxVccAdmStatusEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
            this.addRow(this.atmxVccAdmStatusFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getatmxVccAdmStatusField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccAdmStatusField);
            this.validateatmxVccAdmStatusField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setatmxVccAdmStatusField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.atmxVccAdmStatusField);
                jDMInput.setValue(object);
                this.validateatmxVccAdmStatusField();
            }
        }

        protected boolean validateatmxVccAdmStatusField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccAdmStatusField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.atmxVccAdmStatusFieldLabel.setForeground(Color.yellow);
            } else {
                this.atmxVccAdmStatusFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createatmxVccCircuitTypeField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AtmxVccCircuitType.access", "read-only");
            this.atmxVccCircuitTypeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.atmxVccCircuitTypeFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("atmxVccCircuitTypeLabel"), 2);
            if (this.atmxVccCircuitTypeFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxConnectionModel.AtmxConnDetails.AtmxVccCircuitTypeEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.AtmxVccCircuitTypeEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
                this.addRow(this.atmxVccCircuitTypeFieldLabel, (Component)singleChoiceInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxConnectionModel.AtmxConnDetails.AtmxVccCircuitTypeEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.AtmxVccCircuitTypeEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
            this.addRow(this.atmxVccCircuitTypeFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getatmxVccCircuitTypeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccCircuitTypeField);
            this.validateatmxVccCircuitTypeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setatmxVccCircuitTypeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.atmxVccCircuitTypeField);
                jDMInput.setValue(object);
                this.validateatmxVccCircuitTypeField();
            }
        }

        protected boolean validateatmxVccCircuitTypeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccCircuitTypeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.atmxVccCircuitTypeFieldLabel.setForeground(Color.yellow);
            } else {
                this.atmxVccCircuitTypeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createatmxVccConnTypeField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AtmxVccConnType.access", "read-only");
            this.atmxVccConnTypeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.atmxVccConnTypeFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("atmxVccConnTypeLabel"), 2);
            if (this.atmxVccConnTypeFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxConnectionModel.AtmxConnDetails.AtmxVccConnTypeEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.AtmxVccConnTypeEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
                this.addRow(this.atmxVccConnTypeFieldLabel, (Component)singleChoiceInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxConnectionModel.AtmxConnDetails.AtmxVccConnTypeEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.AtmxVccConnTypeEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
            this.addRow(this.atmxVccConnTypeFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getatmxVccConnTypeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccConnTypeField);
            this.validateatmxVccConnTypeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setatmxVccConnTypeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.atmxVccConnTypeField);
                jDMInput.setValue(object);
                this.validateatmxVccConnTypeField();
            }
        }

        protected boolean validateatmxVccConnTypeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccConnTypeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.atmxVccConnTypeFieldLabel.setForeground(Color.yellow);
            } else {
                this.atmxVccConnTypeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createatmxVccOperStatusField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AtmxVccOperStatus.access", "read-only");
            this.atmxVccOperStatusFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.atmxVccOperStatusFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("atmxVccOperStatusLabel"), 2);
            if (this.atmxVccOperStatusFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxConnectionModel.AtmxConnDetails.AtmxVccOperStatusEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.AtmxVccOperStatusEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
                this.addRow(this.atmxVccOperStatusFieldLabel, (Component)singleChoiceInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxConnectionModel.AtmxConnDetails.AtmxVccOperStatusEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.AtmxVccOperStatusEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
            this.addRow(this.atmxVccOperStatusFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getatmxVccOperStatusField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccOperStatusField);
            this.validateatmxVccOperStatusField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setatmxVccOperStatusField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.atmxVccOperStatusField);
                jDMInput.setValue(object);
                this.validateatmxVccOperStatusField();
            }
        }

        protected boolean validateatmxVccOperStatusField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccOperStatusField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.atmxVccOperStatusFieldLabel.setForeground(Color.yellow);
            } else {
                this.atmxVccOperStatusFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createatmxVccUpTimeField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AtmxVccUpTime.access", "read-only");
            String string2 = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AtmxVccUpTime.length", "31");
            this.atmxVccUpTimeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.atmxVccUpTimeFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("atmxVccUpTimeLabel"), 2);
            if (this.atmxVccUpTimeFieldWritable) {
                StringInput stringInput = new StringInput();
                stringInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.atmxVccUpTimeFieldLabel, (Component)stringInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return stringInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.atmxVccUpTimeFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getatmxVccUpTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccUpTimeField);
            this.validateatmxVccUpTimeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setatmxVccUpTimeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.atmxVccUpTimeField);
                jDMInput.setValue(object);
                this.validateatmxVccUpTimeField();
            }
        }

        protected boolean validateatmxVccUpTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccUpTimeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.atmxVccUpTimeFieldLabel.setForeground(Color.yellow);
            } else {
                this.atmxVccUpTimeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createatmxVccDownTimeField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AtmxVccDownTime.access", "read-only");
            String string2 = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AtmxVccDownTime.length", "31");
            this.atmxVccDownTimeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.atmxVccDownTimeFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("atmxVccDownTimeLabel"), 2);
            if (this.atmxVccDownTimeFieldWritable) {
                StringInput stringInput = new StringInput();
                stringInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.atmxVccDownTimeFieldLabel, (Component)stringInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return stringInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.atmxVccDownTimeFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getatmxVccDownTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccDownTimeField);
            this.validateatmxVccDownTimeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setatmxVccDownTimeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.atmxVccDownTimeField);
                jDMInput.setValue(object);
                this.validateatmxVccDownTimeField();
            }
        }

        protected boolean validateatmxVccDownTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccDownTimeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.atmxVccDownTimeFieldLabel.setForeground(Color.yellow);
            } else {
                this.atmxVccDownTimeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createatmxVccTxMaxFrameSizeField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AtmxVccTxMaxFrameSize.access", "read-write");
            this.atmxVccTxMaxFrameSizeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.atmxVccTxMaxFrameSizeFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("atmxVccTxMaxFrameSizeLabel"), 2);
            if (this.atmxVccTxMaxFrameSizeFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 353208);
                this.addRow(this.atmxVccTxMaxFrameSizeFieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.atmxVccTxMaxFrameSizeFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getatmxVccTxMaxFrameSizeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccTxMaxFrameSizeField);
            this.validateatmxVccTxMaxFrameSizeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setatmxVccTxMaxFrameSizeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.atmxVccTxMaxFrameSizeField);
                jDMInput.setValue(object);
                this.validateatmxVccTxMaxFrameSizeField();
            }
        }

        protected boolean validateatmxVccTxMaxFrameSizeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccTxMaxFrameSizeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.atmxVccTxMaxFrameSizeFieldLabel.setForeground(Color.yellow);
            } else {
                this.atmxVccTxMaxFrameSizeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createatmxVccRxMaxFrameSizeField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AtmxVccRxMaxFrameSize.access", "read-write");
            this.atmxVccRxMaxFrameSizeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.atmxVccRxMaxFrameSizeFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("atmxVccRxMaxFrameSizeLabel"), 2);
            if (this.atmxVccRxMaxFrameSizeFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(64, 32678);
                this.addRow(this.atmxVccRxMaxFrameSizeFieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.atmxVccRxMaxFrameSizeFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getatmxVccRxMaxFrameSizeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccRxMaxFrameSizeField);
            this.validateatmxVccRxMaxFrameSizeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setatmxVccRxMaxFrameSizeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.atmxVccRxMaxFrameSizeField);
                jDMInput.setValue(object);
                this.validateatmxVccRxMaxFrameSizeField();
            }
        }

        protected boolean validateatmxVccRxMaxFrameSizeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmxVccRxMaxFrameSizeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.atmxVccRxMaxFrameSizeFieldLabel.setForeground(Color.yellow);
            } else {
                this.atmxVccRxMaxFrameSizeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.atmxVccSlotField = this.createatmxVccSlotField();
            this.atmxVccPortField = this.createatmxVccPortField();
            this.atmxVccVpiField = this.createatmxVccVpiField();
            this.atmxVccVciField = this.createatmxVccVciField();
            this.atmxVccDescriptionField = this.createatmxVccDescriptionField();
            this.atmxVccAdmStatusField = this.createatmxVccAdmStatusField();
            this.atmxVccCircuitTypeField = this.createatmxVccCircuitTypeField();
            this.atmxVccConnTypeField = this.createatmxVccConnTypeField();
            this.atmxVccOperStatusField = this.createatmxVccOperStatusField();
            this.atmxVccUpTimeField = this.createatmxVccUpTimeField();
            this.atmxVccDownTimeField = this.createatmxVccDownTimeField();
            this.atmxVccTxMaxFrameSizeField = this.createatmxVccTxMaxFrameSizeField();
            this.atmxVccRxMaxFrameSizeField = this.createatmxVccRxMaxFrameSizeField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.atmxVccSlotField)).ignoreValue() && this.atmxVccSlotFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AtmxVccSlot", this.getatmxVccSlotField());
                }
                if (!((JDMInput)((Object)this.atmxVccPortField)).ignoreValue() && this.atmxVccPortFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AtmxVccPort", this.getatmxVccPortField());
                }
                if (!((JDMInput)((Object)this.atmxVccVpiField)).ignoreValue() && this.atmxVccVpiFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AtmxVccVpi", this.getatmxVccVpiField());
                }
                if (!((JDMInput)((Object)this.atmxVccVciField)).ignoreValue() && this.atmxVccVciFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AtmxVccVci", this.getatmxVccVciField());
                }
                if (!((JDMInput)((Object)this.atmxVccDescriptionField)).ignoreValue() && this.atmxVccDescriptionFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AtmxVccDescription", this.getatmxVccDescriptionField());
                }
                if (!((JDMInput)((Object)this.atmxVccAdmStatusField)).ignoreValue() && this.atmxVccAdmStatusFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AtmxVccAdmStatus", this.getatmxVccAdmStatusField());
                }
                if (!((JDMInput)((Object)this.atmxVccCircuitTypeField)).ignoreValue() && this.atmxVccCircuitTypeFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AtmxVccCircuitType", this.getatmxVccCircuitTypeField());
                }
                if (!((JDMInput)((Object)this.atmxVccConnTypeField)).ignoreValue() && this.atmxVccConnTypeFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AtmxVccConnType", this.getatmxVccConnTypeField());
                }
                if (!((JDMInput)((Object)this.atmxVccOperStatusField)).ignoreValue() && this.atmxVccOperStatusFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AtmxVccOperStatus", this.getatmxVccOperStatusField());
                }
                if (!((JDMInput)((Object)this.atmxVccUpTimeField)).ignoreValue() && this.atmxVccUpTimeFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AtmxVccUpTime", this.getatmxVccUpTimeField());
                }
                if (!((JDMInput)((Object)this.atmxVccDownTimeField)).ignoreValue() && this.atmxVccDownTimeFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AtmxVccDownTime", this.getatmxVccDownTimeField());
                }
                if (!((JDMInput)((Object)this.atmxVccTxMaxFrameSizeField)).ignoreValue() && this.atmxVccTxMaxFrameSizeFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AtmxVccTxMaxFrameSize", this.getatmxVccTxMaxFrameSizeField());
                }
                if (!((JDMInput)((Object)this.atmxVccRxMaxFrameSizeField)).ignoreValue() && this.atmxVccRxMaxFrameSizeFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AtmxVccRxMaxFrameSize", this.getatmxVccRxMaxFrameSizeField());
                    return;
                }
            } else {
                AtmConnectionsBasePanel.this.errorsFound = true;
            }
        }

        public void reset() {
            AtmConnectionsBasePanel.this.displayMsg(AtmConnectionsBasePanel.getNLSString("accessDataMsg"));
            try {
                this.setatmxVccSlotField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccSlot", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setatmxVccPortField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccPort", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setatmxVccVpiField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccVpi", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setatmxVccVciField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccVci", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setatmxVccDescriptionField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccDescription", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setatmxVccAdmStatusField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccAdmStatus", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setatmxVccCircuitTypeField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccCircuitType", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setatmxVccConnTypeField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccConnType", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setatmxVccOperStatusField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccOperStatus", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setatmxVccUpTimeField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccUpTime", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setatmxVccDownTimeField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccDownTime", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setatmxVccTxMaxFrameSizeField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccTxMaxFrameSize", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setatmxVccRxMaxFrameSizeField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccRxMaxFrameSize", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            }
            catch (NullPointerException nullPointerException) {}
            AtmConnectionsBasePanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.setatmxVccSlotField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccSlot", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setatmxVccPortField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccPort", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setatmxVccVpiField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccVpi", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setatmxVccVciField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccVci", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setatmxVccDescriptionField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccDescription", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setatmxVccAdmStatusField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccAdmStatus", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setatmxVccCircuitTypeField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccCircuitType", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setatmxVccConnTypeField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccConnType", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setatmxVccOperStatusField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccOperStatus", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setatmxVccUpTimeField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccUpTime", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setatmxVccDownTimeField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccDownTime", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setatmxVccTxMaxFrameSizeField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccTxMaxFrameSize", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setatmxVccRxMaxFrameSizeField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AtmxVccRxMaxFrameSize", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.doLayout();
        }

        public boolean validateSection() {
            if (!((JDMInput)((Object)this.atmxVccRxMaxFrameSizeField)).ignoreValue() && !this.validateatmxVccRxMaxFrameSizeField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.atmxVccTxMaxFrameSizeField)).ignoreValue() && !this.validateatmxVccTxMaxFrameSizeField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.atmxVccAdmStatusField)).ignoreValue() && !this.validateatmxVccAdmStatusField()) {
                return false;
            }
            return ((JDMInput)((Object)this.atmxVccDescriptionField)).ignoreValue() || this.validateatmxVccDescriptionField();
        }
    }

    public class AtmVccReqQosSection
    extends PropertySection {
        ModelInfo chunk;
        Component vccReqTxTrafQoSClassField;
        Component vccReqTxTrafBestEffortField;
        Component vccReqTxTrafDescriptorField;
        Component vccReqTxTrafDescParam1Field;
        Component vccReqTxTrafDescParam2Field;
        Component vccReqTxTrafDescParam3Field;
        Component vccReqRxTrafQoSClassField;
        Component vccReqRxTrafBestEffortField;
        Component vccReqRxTrafDescriptorField;
        Component vccReqRxTrafDescParam1Field;
        Component vccReqRxTrafDescParam2Field;
        Component vccReqRxTrafDescParam3Field;
        Label vccReqTxTrafQoSClassFieldLabel;
        Label vccReqTxTrafBestEffortFieldLabel;
        Label vccReqTxTrafDescriptorFieldLabel;
        Label vccReqTxTrafDescParam1FieldLabel;
        Label vccReqTxTrafDescParam2FieldLabel;
        Label vccReqTxTrafDescParam3FieldLabel;
        Label vccReqRxTrafQoSClassFieldLabel;
        Label vccReqRxTrafBestEffortFieldLabel;
        Label vccReqRxTrafDescriptorFieldLabel;
        Label vccReqRxTrafDescParam1FieldLabel;
        Label vccReqRxTrafDescParam2FieldLabel;
        Label vccReqRxTrafDescParam3FieldLabel;
        boolean vccReqTxTrafQoSClassFieldWritable = false;
        boolean vccReqTxTrafBestEffortFieldWritable = false;
        boolean vccReqTxTrafDescriptorFieldWritable = false;
        boolean vccReqTxTrafDescParam1FieldWritable = false;
        boolean vccReqTxTrafDescParam2FieldWritable = false;
        boolean vccReqTxTrafDescParam3FieldWritable = false;
        boolean vccReqRxTrafQoSClassFieldWritable = false;
        boolean vccReqRxTrafBestEffortFieldWritable = false;
        boolean vccReqRxTrafDescriptorFieldWritable = false;
        boolean vccReqRxTrafDescParam1FieldWritable = false;
        boolean vccReqRxTrafDescParam2FieldWritable = false;
        boolean vccReqRxTrafDescParam3FieldWritable = false;

        public AtmVccReqQosSection() {
            AtmConnectionsBasePanel.this = AtmConnectionsBasePanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createvccReqTxTrafQoSClassField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ReqTxTrafQoSClass.access", "read-only");
            this.vccReqTxTrafQoSClassFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccReqTxTrafQoSClassFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccReqTxTrafQoSClassLabel"), 2);
            if (this.vccReqTxTrafQoSClassFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxConnectionModel.AtmxConnDetails.ReqTxTrafQoSClassEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ReqTxTrafQoSClassEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
                this.addRow(this.vccReqTxTrafQoSClassFieldLabel, (Component)singleChoiceInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxConnectionModel.AtmxConnDetails.ReqTxTrafQoSClassEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ReqTxTrafQoSClassEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
            this.addRow(this.vccReqTxTrafQoSClassFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getvccReqTxTrafQoSClassField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqTxTrafQoSClassField);
            this.validatevccReqTxTrafQoSClassField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccReqTxTrafQoSClassField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccReqTxTrafQoSClassField);
                jDMInput.setValue(object);
                this.validatevccReqTxTrafQoSClassField();
            }
        }

        protected boolean validatevccReqTxTrafQoSClassField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqTxTrafQoSClassField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccReqTxTrafQoSClassFieldLabel.setForeground(Color.yellow);
            } else {
                this.vccReqTxTrafQoSClassFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccReqTxTrafBestEffortField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ReqTxTrafBestEffort.access", "read-write");
            this.vccReqTxTrafBestEffortFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccReqTxTrafBestEffortFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccReqTxTrafBestEffortLabel"), 2);
            if (this.vccReqTxTrafBestEffortFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxConnectionModel.AtmxConnDetails.ReqTxTrafBestEffortEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ReqTxTrafBestEffortEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
                this.addRow(this.vccReqTxTrafBestEffortFieldLabel, (Component)singleChoiceInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxConnectionModel.AtmxConnDetails.ReqTxTrafBestEffortEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ReqTxTrafBestEffortEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
            this.addRow(this.vccReqTxTrafBestEffortFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getvccReqTxTrafBestEffortField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqTxTrafBestEffortField);
            this.validatevccReqTxTrafBestEffortField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccReqTxTrafBestEffortField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccReqTxTrafBestEffortField);
                jDMInput.setValue(object);
                this.validatevccReqTxTrafBestEffortField();
            }
        }

        protected boolean validatevccReqTxTrafBestEffortField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqTxTrafBestEffortField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccReqTxTrafBestEffortFieldLabel.setForeground(Color.yellow);
            } else {
                this.vccReqTxTrafBestEffortFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccReqTxTrafDescriptorField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ReqTxTrafDescriptor.access", "read-write");
            this.vccReqTxTrafDescriptorFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccReqTxTrafDescriptorFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccReqTxTrafDescriptorLabel"), 2);
            if (this.vccReqTxTrafDescriptorFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxConnectionModel.AtmxConnDetails.ReqTxTrafDescriptorEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ReqTxTrafDescriptorEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
                this.addRow(this.vccReqTxTrafDescriptorFieldLabel, (Component)singleChoiceInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxConnectionModel.AtmxConnDetails.ReqTxTrafDescriptorEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ReqTxTrafDescriptorEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
            this.addRow(this.vccReqTxTrafDescriptorFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getvccReqTxTrafDescriptorField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqTxTrafDescriptorField);
            this.validatevccReqTxTrafDescriptorField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccReqTxTrafDescriptorField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccReqTxTrafDescriptorField);
                jDMInput.setValue(object);
                this.validatevccReqTxTrafDescriptorField();
            }
        }

        protected boolean validatevccReqTxTrafDescriptorField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqTxTrafDescriptorField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccReqTxTrafDescriptorFieldLabel.setForeground(Color.yellow);
            } else {
                this.vccReqTxTrafDescriptorFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccReqTxTrafDescParam1Field() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ReqTxTrafDescParam1.access", "read-write");
            this.vccReqTxTrafDescParam1FieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccReqTxTrafDescParam1FieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccReqTxTrafDescParam1Label"), 2);
            if (this.vccReqTxTrafDescParam1FieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 353208);
                this.addRow(this.vccReqTxTrafDescParam1FieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.vccReqTxTrafDescParam1FieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getvccReqTxTrafDescParam1Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqTxTrafDescParam1Field);
            this.validatevccReqTxTrafDescParam1Field();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccReqTxTrafDescParam1Field(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccReqTxTrafDescParam1Field);
                jDMInput.setValue(object);
                this.validatevccReqTxTrafDescParam1Field();
            }
        }

        protected boolean validatevccReqTxTrafDescParam1Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqTxTrafDescParam1Field);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccReqTxTrafDescParam1FieldLabel.setForeground(Color.yellow);
            } else {
                this.vccReqTxTrafDescParam1FieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccReqTxTrafDescParam2Field() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ReqTxTrafDescParam2.access", "read-only");
            this.vccReqTxTrafDescParam2FieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccReqTxTrafDescParam2FieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccReqTxTrafDescParam2Label"), 2);
            if (this.vccReqTxTrafDescParam2FieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 353208);
                this.addRow(this.vccReqTxTrafDescParam2FieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.vccReqTxTrafDescParam2FieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getvccReqTxTrafDescParam2Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqTxTrafDescParam2Field);
            this.validatevccReqTxTrafDescParam2Field();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccReqTxTrafDescParam2Field(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccReqTxTrafDescParam2Field);
                jDMInput.setValue(object);
                this.validatevccReqTxTrafDescParam2Field();
            }
        }

        protected boolean validatevccReqTxTrafDescParam2Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqTxTrafDescParam2Field);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccReqTxTrafDescParam2FieldLabel.setForeground(Color.yellow);
            } else {
                this.vccReqTxTrafDescParam2FieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccReqTxTrafDescParam3Field() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ReqTxTrafDescParam3.access", "read-only");
            this.vccReqTxTrafDescParam3FieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccReqTxTrafDescParam3FieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccReqTxTrafDescParam3Label"), 2);
            if (this.vccReqTxTrafDescParam3FieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 353208);
                this.addRow(this.vccReqTxTrafDescParam3FieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.vccReqTxTrafDescParam3FieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getvccReqTxTrafDescParam3Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqTxTrafDescParam3Field);
            this.validatevccReqTxTrafDescParam3Field();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccReqTxTrafDescParam3Field(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccReqTxTrafDescParam3Field);
                jDMInput.setValue(object);
                this.validatevccReqTxTrafDescParam3Field();
            }
        }

        protected boolean validatevccReqTxTrafDescParam3Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqTxTrafDescParam3Field);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccReqTxTrafDescParam3FieldLabel.setForeground(Color.yellow);
            } else {
                this.vccReqTxTrafDescParam3FieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccReqRxTrafQoSClassField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ReqRxTrafQoSClass.access", "read-only");
            this.vccReqRxTrafQoSClassFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccReqRxTrafQoSClassFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccReqRxTrafQoSClassLabel"), 2);
            if (this.vccReqRxTrafQoSClassFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxConnectionModel.AtmxConnDetails.ReqRxTrafQoSClassEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ReqRxTrafQoSClassEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
                this.addRow(this.vccReqRxTrafQoSClassFieldLabel, (Component)singleChoiceInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxConnectionModel.AtmxConnDetails.ReqRxTrafQoSClassEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ReqRxTrafQoSClassEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
            this.addRow(this.vccReqRxTrafQoSClassFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getvccReqRxTrafQoSClassField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqRxTrafQoSClassField);
            this.validatevccReqRxTrafQoSClassField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccReqRxTrafQoSClassField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccReqRxTrafQoSClassField);
                jDMInput.setValue(object);
                this.validatevccReqRxTrafQoSClassField();
            }
        }

        protected boolean validatevccReqRxTrafQoSClassField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqRxTrafQoSClassField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccReqRxTrafQoSClassFieldLabel.setForeground(Color.yellow);
            } else {
                this.vccReqRxTrafQoSClassFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccReqRxTrafBestEffortField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ReqRxTrafBestEffort.access", "read-write");
            this.vccReqRxTrafBestEffortFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccReqRxTrafBestEffortFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccReqRxTrafBestEffortLabel"), 2);
            if (this.vccReqRxTrafBestEffortFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxConnectionModel.AtmxConnDetails.ReqRxTrafBestEffortEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ReqRxTrafBestEffortEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
                this.addRow(this.vccReqRxTrafBestEffortFieldLabel, (Component)singleChoiceInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxConnectionModel.AtmxConnDetails.ReqRxTrafBestEffortEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ReqRxTrafBestEffortEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
            this.addRow(this.vccReqRxTrafBestEffortFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getvccReqRxTrafBestEffortField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqRxTrafBestEffortField);
            this.validatevccReqRxTrafBestEffortField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccReqRxTrafBestEffortField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccReqRxTrafBestEffortField);
                jDMInput.setValue(object);
                this.validatevccReqRxTrafBestEffortField();
            }
        }

        protected boolean validatevccReqRxTrafBestEffortField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqRxTrafBestEffortField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccReqRxTrafBestEffortFieldLabel.setForeground(Color.yellow);
            } else {
                this.vccReqRxTrafBestEffortFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccReqRxTrafDescriptorField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ReqRxTrafDescriptor.access", "read-write");
            this.vccReqRxTrafDescriptorFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccReqRxTrafDescriptorFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccReqRxTrafDescriptorLabel"), 2);
            if (this.vccReqRxTrafDescriptorFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxConnectionModel.AtmxConnDetails.ReqRxTrafDescriptorEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ReqRxTrafDescriptorEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
                this.addRow(this.vccReqRxTrafDescriptorFieldLabel, (Component)singleChoiceInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxConnectionModel.AtmxConnDetails.ReqRxTrafDescriptorEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ReqRxTrafDescriptorEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
            this.addRow(this.vccReqRxTrafDescriptorFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getvccReqRxTrafDescriptorField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqRxTrafDescriptorField);
            this.validatevccReqRxTrafDescriptorField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccReqRxTrafDescriptorField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccReqRxTrafDescriptorField);
                jDMInput.setValue(object);
                this.validatevccReqRxTrafDescriptorField();
            }
        }

        protected boolean validatevccReqRxTrafDescriptorField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqRxTrafDescriptorField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccReqRxTrafDescriptorFieldLabel.setForeground(Color.yellow);
            } else {
                this.vccReqRxTrafDescriptorFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccReqRxTrafDescParam1Field() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ReqRxTrafDescParam1.access", "read-write");
            this.vccReqRxTrafDescParam1FieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccReqRxTrafDescParam1FieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccReqRxTrafDescParam1Label"), 2);
            if (this.vccReqRxTrafDescParam1FieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 353208);
                this.addRow(this.vccReqRxTrafDescParam1FieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.vccReqRxTrafDescParam1FieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getvccReqRxTrafDescParam1Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqRxTrafDescParam1Field);
            this.validatevccReqRxTrafDescParam1Field();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccReqRxTrafDescParam1Field(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccReqRxTrafDescParam1Field);
                jDMInput.setValue(object);
                this.validatevccReqRxTrafDescParam1Field();
            }
        }

        protected boolean validatevccReqRxTrafDescParam1Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqRxTrafDescParam1Field);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccReqRxTrafDescParam1FieldLabel.setForeground(Color.yellow);
            } else {
                this.vccReqRxTrafDescParam1FieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccReqRxTrafDescParam2Field() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ReqRxTrafDescParam2.access", "read-only");
            this.vccReqRxTrafDescParam2FieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccReqRxTrafDescParam2FieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccReqRxTrafDescParam2Label"), 2);
            if (this.vccReqRxTrafDescParam2FieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 353208);
                this.addRow(this.vccReqRxTrafDescParam2FieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.vccReqRxTrafDescParam2FieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getvccReqRxTrafDescParam2Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqRxTrafDescParam2Field);
            this.validatevccReqRxTrafDescParam2Field();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccReqRxTrafDescParam2Field(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccReqRxTrafDescParam2Field);
                jDMInput.setValue(object);
                this.validatevccReqRxTrafDescParam2Field();
            }
        }

        protected boolean validatevccReqRxTrafDescParam2Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqRxTrafDescParam2Field);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccReqRxTrafDescParam2FieldLabel.setForeground(Color.yellow);
            } else {
                this.vccReqRxTrafDescParam2FieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccReqRxTrafDescParam3Field() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ReqRxTrafDescParam3.access", "read-only");
            this.vccReqRxTrafDescParam3FieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccReqRxTrafDescParam3FieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccReqRxTrafDescParam3Label"), 2);
            if (this.vccReqRxTrafDescParam3FieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 353208);
                this.addRow(this.vccReqRxTrafDescParam3FieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.vccReqRxTrafDescParam3FieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getvccReqRxTrafDescParam3Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqRxTrafDescParam3Field);
            this.validatevccReqRxTrafDescParam3Field();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccReqRxTrafDescParam3Field(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccReqRxTrafDescParam3Field);
                jDMInput.setValue(object);
                this.validatevccReqRxTrafDescParam3Field();
            }
        }

        protected boolean validatevccReqRxTrafDescParam3Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccReqRxTrafDescParam3Field);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccReqRxTrafDescParam3FieldLabel.setForeground(Color.yellow);
            } else {
                this.vccReqRxTrafDescParam3FieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.vccReqTxTrafQoSClassField = this.createvccReqTxTrafQoSClassField();
            this.vccReqTxTrafBestEffortField = this.createvccReqTxTrafBestEffortField();
            this.vccReqTxTrafDescriptorField = this.createvccReqTxTrafDescriptorField();
            this.vccReqTxTrafDescParam1Field = this.createvccReqTxTrafDescParam1Field();
            this.vccReqTxTrafDescParam2Field = this.createvccReqTxTrafDescParam2Field();
            this.vccReqTxTrafDescParam3Field = this.createvccReqTxTrafDescParam3Field();
            this.vccReqRxTrafQoSClassField = this.createvccReqRxTrafQoSClassField();
            this.vccReqRxTrafBestEffortField = this.createvccReqRxTrafBestEffortField();
            this.vccReqRxTrafDescriptorField = this.createvccReqRxTrafDescriptorField();
            this.vccReqRxTrafDescParam1Field = this.createvccReqRxTrafDescParam1Field();
            this.vccReqRxTrafDescParam2Field = this.createvccReqRxTrafDescParam2Field();
            this.vccReqRxTrafDescParam3Field = this.createvccReqRxTrafDescParam3Field();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.vccReqTxTrafQoSClassField)).ignoreValue() && this.vccReqTxTrafQoSClassFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ReqTxTrafQoSClass", this.getvccReqTxTrafQoSClassField());
                }
                if (!((JDMInput)((Object)this.vccReqTxTrafBestEffortField)).ignoreValue() && this.vccReqTxTrafBestEffortFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ReqTxTrafBestEffort", this.getvccReqTxTrafBestEffortField());
                }
                if (!((JDMInput)((Object)this.vccReqTxTrafDescriptorField)).ignoreValue() && this.vccReqTxTrafDescriptorFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ReqTxTrafDescriptor", this.getvccReqTxTrafDescriptorField());
                }
                if (!((JDMInput)((Object)this.vccReqTxTrafDescParam1Field)).ignoreValue() && this.vccReqTxTrafDescParam1FieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ReqTxTrafDescParam1", this.getvccReqTxTrafDescParam1Field());
                }
                if (!((JDMInput)((Object)this.vccReqTxTrafDescParam2Field)).ignoreValue() && this.vccReqTxTrafDescParam2FieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ReqTxTrafDescParam2", this.getvccReqTxTrafDescParam2Field());
                }
                if (!((JDMInput)((Object)this.vccReqTxTrafDescParam3Field)).ignoreValue() && this.vccReqTxTrafDescParam3FieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ReqTxTrafDescParam3", this.getvccReqTxTrafDescParam3Field());
                }
                if (!((JDMInput)((Object)this.vccReqRxTrafQoSClassField)).ignoreValue() && this.vccReqRxTrafQoSClassFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ReqRxTrafQoSClass", this.getvccReqRxTrafQoSClassField());
                }
                if (!((JDMInput)((Object)this.vccReqRxTrafBestEffortField)).ignoreValue() && this.vccReqRxTrafBestEffortFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ReqRxTrafBestEffort", this.getvccReqRxTrafBestEffortField());
                }
                if (!((JDMInput)((Object)this.vccReqRxTrafDescriptorField)).ignoreValue() && this.vccReqRxTrafDescriptorFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ReqRxTrafDescriptor", this.getvccReqRxTrafDescriptorField());
                }
                if (!((JDMInput)((Object)this.vccReqRxTrafDescParam1Field)).ignoreValue() && this.vccReqRxTrafDescParam1FieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ReqRxTrafDescParam1", this.getvccReqRxTrafDescParam1Field());
                }
                if (!((JDMInput)((Object)this.vccReqRxTrafDescParam2Field)).ignoreValue() && this.vccReqRxTrafDescParam2FieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ReqRxTrafDescParam2", this.getvccReqRxTrafDescParam2Field());
                }
                if (!((JDMInput)((Object)this.vccReqRxTrafDescParam3Field)).ignoreValue() && this.vccReqRxTrafDescParam3FieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ReqRxTrafDescParam3", this.getvccReqRxTrafDescParam3Field());
                    return;
                }
            } else {
                AtmConnectionsBasePanel.this.errorsFound = true;
            }
        }

        public void reset() {
            AtmConnectionsBasePanel.this.displayMsg(AtmConnectionsBasePanel.getNLSString("accessDataMsg"));
            try {
                this.setvccReqTxTrafQoSClassField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqTxTrafQoSClass", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccReqTxTrafBestEffortField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqTxTrafBestEffort", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccReqTxTrafDescriptorField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqTxTrafDescriptor", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccReqTxTrafDescParam1Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqTxTrafDescParam1", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccReqTxTrafDescParam2Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqTxTrafDescParam2", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccReqTxTrafDescParam3Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqTxTrafDescParam3", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccReqRxTrafQoSClassField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqRxTrafQoSClass", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccReqRxTrafBestEffortField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqRxTrafBestEffort", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccReqRxTrafDescriptorField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqRxTrafDescriptor", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccReqRxTrafDescParam1Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqRxTrafDescParam1", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccReqRxTrafDescParam2Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqRxTrafDescParam2", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccReqRxTrafDescParam3Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqRxTrafDescParam3", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            }
            catch (NullPointerException nullPointerException) {}
            AtmConnectionsBasePanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.setvccReqTxTrafQoSClassField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqTxTrafQoSClass", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccReqTxTrafBestEffortField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqTxTrafBestEffort", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccReqTxTrafDescriptorField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqTxTrafDescriptor", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccReqTxTrafDescParam1Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqTxTrafDescParam1", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccReqTxTrafDescParam2Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqTxTrafDescParam2", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccReqTxTrafDescParam3Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqTxTrafDescParam3", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccReqRxTrafQoSClassField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqRxTrafQoSClass", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccReqRxTrafBestEffortField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqRxTrafBestEffort", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccReqRxTrafDescriptorField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqRxTrafDescriptor", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccReqRxTrafDescParam1Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqRxTrafDescParam1", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccReqRxTrafDescParam2Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqRxTrafDescParam2", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccReqRxTrafDescParam3Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ReqRxTrafDescParam3", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.doLayout();
        }

        public boolean validateSection() {
            if (!((JDMInput)((Object)this.vccReqRxTrafBestEffortField)).ignoreValue() && !this.validatevccReqRxTrafBestEffortField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.vccReqTxTrafBestEffortField)).ignoreValue() && !this.validatevccReqTxTrafBestEffortField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.vccReqRxTrafDescriptorField)).ignoreValue() && !this.validatevccReqRxTrafDescriptorField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.vccReqTxTrafDescriptorField)).ignoreValue() && !this.validatevccReqTxTrafDescriptorField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.vccReqRxTrafDescParam1Field)).ignoreValue() && !this.validatevccReqRxTrafDescParam1Field()) {
                return false;
            }
            return ((JDMInput)((Object)this.vccReqTxTrafDescParam1Field)).ignoreValue() || this.validatevccReqTxTrafDescParam1Field();
        }
    }

    public class AtmVccAccQosSection
    extends PropertySection {
        ModelInfo chunk;
        Component vccAccTxTrafQoSClassField;
        Component vccAccTxTrafBestEffortField;
        Component vccAccTxTrafDescriptorField;
        Component vccAccTxTrafDescParam1Field;
        Component vccAccTxTrafDescParam2Field;
        Component vccAccTxTrafDescParam3Field;
        Component vccAccRxTrafQoSClassField;
        Component vccAccRxTrafBestEffortField;
        Component vccAccRxTrafDescriptorField;
        Component vccAccRxTrafDescParam1Field;
        Component vccAccRxTrafDescParam2Field;
        Component vccAccRxTrafDescParam3Field;
        Label vccAccTxTrafQoSClassFieldLabel;
        Label vccAccTxTrafBestEffortFieldLabel;
        Label vccAccTxTrafDescriptorFieldLabel;
        Label vccAccTxTrafDescParam1FieldLabel;
        Label vccAccTxTrafDescParam2FieldLabel;
        Label vccAccTxTrafDescParam3FieldLabel;
        Label vccAccRxTrafQoSClassFieldLabel;
        Label vccAccRxTrafBestEffortFieldLabel;
        Label vccAccRxTrafDescriptorFieldLabel;
        Label vccAccRxTrafDescParam1FieldLabel;
        Label vccAccRxTrafDescParam2FieldLabel;
        Label vccAccRxTrafDescParam3FieldLabel;
        boolean vccAccTxTrafQoSClassFieldWritable = false;
        boolean vccAccTxTrafBestEffortFieldWritable = false;
        boolean vccAccTxTrafDescriptorFieldWritable = false;
        boolean vccAccTxTrafDescParam1FieldWritable = false;
        boolean vccAccTxTrafDescParam2FieldWritable = false;
        boolean vccAccTxTrafDescParam3FieldWritable = false;
        boolean vccAccRxTrafQoSClassFieldWritable = false;
        boolean vccAccRxTrafBestEffortFieldWritable = false;
        boolean vccAccRxTrafDescriptorFieldWritable = false;
        boolean vccAccRxTrafDescParam1FieldWritable = false;
        boolean vccAccRxTrafDescParam2FieldWritable = false;
        boolean vccAccRxTrafDescParam3FieldWritable = false;

        public AtmVccAccQosSection() {
            AtmConnectionsBasePanel.this = AtmConnectionsBasePanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createvccAccTxTrafQoSClassField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AccTxTrafQoSClass.access", "read-only");
            this.vccAccTxTrafQoSClassFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccAccTxTrafQoSClassFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccAccTxTrafQoSClassLabel"), 2);
            if (this.vccAccTxTrafQoSClassFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxConnectionModel.AtmxConnDetails.AccTxTrafQoSClassEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.AccTxTrafQoSClassEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
                this.addRow(this.vccAccTxTrafQoSClassFieldLabel, (Component)singleChoiceInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxConnectionModel.AtmxConnDetails.AccTxTrafQoSClassEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.AccTxTrafQoSClassEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
            this.addRow(this.vccAccTxTrafQoSClassFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getvccAccTxTrafQoSClassField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccTxTrafQoSClassField);
            this.validatevccAccTxTrafQoSClassField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccAccTxTrafQoSClassField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccAccTxTrafQoSClassField);
                jDMInput.setValue(object);
                this.validatevccAccTxTrafQoSClassField();
            }
        }

        protected boolean validatevccAccTxTrafQoSClassField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccTxTrafQoSClassField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccAccTxTrafQoSClassFieldLabel.setForeground(Color.yellow);
            } else {
                this.vccAccTxTrafQoSClassFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccAccTxTrafBestEffortField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AccTxTrafBestEffort.access", "read-write");
            this.vccAccTxTrafBestEffortFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccAccTxTrafBestEffortFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccAccTxTrafBestEffortLabel"), 2);
            if (this.vccAccTxTrafBestEffortFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxConnectionModel.AtmxConnDetails.AccTxTrafBestEffortEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.AccTxTrafBestEffortEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
                this.addRow(this.vccAccTxTrafBestEffortFieldLabel, (Component)singleChoiceInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxConnectionModel.AtmxConnDetails.AccTxTrafBestEffortEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.AccTxTrafBestEffortEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
            this.addRow(this.vccAccTxTrafBestEffortFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getvccAccTxTrafBestEffortField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccTxTrafBestEffortField);
            this.validatevccAccTxTrafBestEffortField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccAccTxTrafBestEffortField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccAccTxTrafBestEffortField);
                jDMInput.setValue(object);
                this.validatevccAccTxTrafBestEffortField();
            }
        }

        protected boolean validatevccAccTxTrafBestEffortField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccTxTrafBestEffortField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccAccTxTrafBestEffortFieldLabel.setForeground(Color.yellow);
            } else {
                this.vccAccTxTrafBestEffortFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccAccTxTrafDescriptorField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AccTxTrafDescriptor.access", "read-write");
            this.vccAccTxTrafDescriptorFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccAccTxTrafDescriptorFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccAccTxTrafDescriptorLabel"), 2);
            if (this.vccAccTxTrafDescriptorFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxConnectionModel.AtmxConnDetails.AccTxTrafDescriptorEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.AccTxTrafDescriptorEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
                this.addRow(this.vccAccTxTrafDescriptorFieldLabel, (Component)singleChoiceInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxConnectionModel.AtmxConnDetails.AccTxTrafDescriptorEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.AccTxTrafDescriptorEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
            this.addRow(this.vccAccTxTrafDescriptorFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getvccAccTxTrafDescriptorField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccTxTrafDescriptorField);
            this.validatevccAccTxTrafDescriptorField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccAccTxTrafDescriptorField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccAccTxTrafDescriptorField);
                jDMInput.setValue(object);
                this.validatevccAccTxTrafDescriptorField();
            }
        }

        protected boolean validatevccAccTxTrafDescriptorField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccTxTrafDescriptorField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccAccTxTrafDescriptorFieldLabel.setForeground(Color.yellow);
            } else {
                this.vccAccTxTrafDescriptorFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccAccTxTrafDescParam1Field() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AccTxTrafDescParam1.access", "read-write");
            this.vccAccTxTrafDescParam1FieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccAccTxTrafDescParam1FieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccAccTxTrafDescParam1Label"), 2);
            if (this.vccAccTxTrafDescParam1FieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 353208);
                this.addRow(this.vccAccTxTrafDescParam1FieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.vccAccTxTrafDescParam1FieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getvccAccTxTrafDescParam1Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccTxTrafDescParam1Field);
            this.validatevccAccTxTrafDescParam1Field();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccAccTxTrafDescParam1Field(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccAccTxTrafDescParam1Field);
                jDMInput.setValue(object);
                this.validatevccAccTxTrafDescParam1Field();
            }
        }

        protected boolean validatevccAccTxTrafDescParam1Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccTxTrafDescParam1Field);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccAccTxTrafDescParam1FieldLabel.setForeground(Color.yellow);
            } else {
                this.vccAccTxTrafDescParam1FieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccAccTxTrafDescParam2Field() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AccTxTrafDescParam2.access", "read-only");
            this.vccAccTxTrafDescParam2FieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccAccTxTrafDescParam2FieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccAccTxTrafDescParam2Label"), 2);
            if (this.vccAccTxTrafDescParam2FieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 353208);
                this.addRow(this.vccAccTxTrafDescParam2FieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.vccAccTxTrafDescParam2FieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getvccAccTxTrafDescParam2Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccTxTrafDescParam2Field);
            this.validatevccAccTxTrafDescParam2Field();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccAccTxTrafDescParam2Field(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccAccTxTrafDescParam2Field);
                jDMInput.setValue(object);
                this.validatevccAccTxTrafDescParam2Field();
            }
        }

        protected boolean validatevccAccTxTrafDescParam2Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccTxTrafDescParam2Field);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccAccTxTrafDescParam2FieldLabel.setForeground(Color.yellow);
            } else {
                this.vccAccTxTrafDescParam2FieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccAccTxTrafDescParam3Field() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AccTxTrafDescParam3.access", "read-only");
            this.vccAccTxTrafDescParam3FieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccAccTxTrafDescParam3FieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccAccTxTrafDescParam3Label"), 2);
            if (this.vccAccTxTrafDescParam3FieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 353208);
                this.addRow(this.vccAccTxTrafDescParam3FieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.vccAccTxTrafDescParam3FieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getvccAccTxTrafDescParam3Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccTxTrafDescParam3Field);
            this.validatevccAccTxTrafDescParam3Field();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccAccTxTrafDescParam3Field(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccAccTxTrafDescParam3Field);
                jDMInput.setValue(object);
                this.validatevccAccTxTrafDescParam3Field();
            }
        }

        protected boolean validatevccAccTxTrafDescParam3Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccTxTrafDescParam3Field);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccAccTxTrafDescParam3FieldLabel.setForeground(Color.yellow);
            } else {
                this.vccAccTxTrafDescParam3FieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccAccRxTrafQoSClassField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AccRxTrafQoSClass.access", "read-only");
            this.vccAccRxTrafQoSClassFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccAccRxTrafQoSClassFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccAccRxTrafQoSClassLabel"), 2);
            if (this.vccAccRxTrafQoSClassFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxConnectionModel.AtmxConnDetails.AccRxTrafQoSClassEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.AccRxTrafQoSClassEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
                this.addRow(this.vccAccRxTrafQoSClassFieldLabel, (Component)singleChoiceInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxConnectionModel.AtmxConnDetails.AccRxTrafQoSClassEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.AccRxTrafQoSClassEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
            this.addRow(this.vccAccRxTrafQoSClassFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getvccAccRxTrafQoSClassField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccRxTrafQoSClassField);
            this.validatevccAccRxTrafQoSClassField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccAccRxTrafQoSClassField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccAccRxTrafQoSClassField);
                jDMInput.setValue(object);
                this.validatevccAccRxTrafQoSClassField();
            }
        }

        protected boolean validatevccAccRxTrafQoSClassField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccRxTrafQoSClassField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccAccRxTrafQoSClassFieldLabel.setForeground(Color.yellow);
            } else {
                this.vccAccRxTrafQoSClassFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccAccRxTrafBestEffortField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AccRxTrafBestEffort.access", "read-write");
            this.vccAccRxTrafBestEffortFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccAccRxTrafBestEffortFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccAccRxTrafBestEffortLabel"), 2);
            if (this.vccAccRxTrafBestEffortFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxConnectionModel.AtmxConnDetails.AccRxTrafBestEffortEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.AccRxTrafBestEffortEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
                this.addRow(this.vccAccRxTrafBestEffortFieldLabel, (Component)singleChoiceInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxConnectionModel.AtmxConnDetails.AccRxTrafBestEffortEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.AccRxTrafBestEffortEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
            this.addRow(this.vccAccRxTrafBestEffortFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getvccAccRxTrafBestEffortField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccRxTrafBestEffortField);
            this.validatevccAccRxTrafBestEffortField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccAccRxTrafBestEffortField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccAccRxTrafBestEffortField);
                jDMInput.setValue(object);
                this.validatevccAccRxTrafBestEffortField();
            }
        }

        protected boolean validatevccAccRxTrafBestEffortField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccRxTrafBestEffortField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccAccRxTrafBestEffortFieldLabel.setForeground(Color.yellow);
            } else {
                this.vccAccRxTrafBestEffortFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccAccRxTrafDescriptorField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AccRxTrafDescriptor.access", "read-write");
            this.vccAccRxTrafDescriptorFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccAccRxTrafDescriptorFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccAccRxTrafDescriptorLabel"), 2);
            if (this.vccAccRxTrafDescriptorFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxConnectionModel.AtmxConnDetails.AccRxTrafDescriptorEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.AccRxTrafDescriptorEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
                this.addRow(this.vccAccRxTrafDescriptorFieldLabel, (Component)singleChoiceInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxConnectionModel.AtmxConnDetails.AccRxTrafDescriptorEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.AccRxTrafDescriptorEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
            this.addRow(this.vccAccRxTrafDescriptorFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getvccAccRxTrafDescriptorField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccRxTrafDescriptorField);
            this.validatevccAccRxTrafDescriptorField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccAccRxTrafDescriptorField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccAccRxTrafDescriptorField);
                jDMInput.setValue(object);
                this.validatevccAccRxTrafDescriptorField();
            }
        }

        protected boolean validatevccAccRxTrafDescriptorField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccRxTrafDescriptorField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccAccRxTrafDescriptorFieldLabel.setForeground(Color.yellow);
            } else {
                this.vccAccRxTrafDescriptorFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccAccRxTrafDescParam1Field() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AccRxTrafDescParam1.access", "read-write");
            this.vccAccRxTrafDescParam1FieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccAccRxTrafDescParam1FieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccAccRxTrafDescParam1Label"), 2);
            if (this.vccAccRxTrafDescParam1FieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 353208);
                this.addRow(this.vccAccRxTrafDescParam1FieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.vccAccRxTrafDescParam1FieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getvccAccRxTrafDescParam1Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccRxTrafDescParam1Field);
            this.validatevccAccRxTrafDescParam1Field();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccAccRxTrafDescParam1Field(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccAccRxTrafDescParam1Field);
                jDMInput.setValue(object);
                this.validatevccAccRxTrafDescParam1Field();
            }
        }

        protected boolean validatevccAccRxTrafDescParam1Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccRxTrafDescParam1Field);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccAccRxTrafDescParam1FieldLabel.setForeground(Color.yellow);
            } else {
                this.vccAccRxTrafDescParam1FieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccAccRxTrafDescParam2Field() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AccRxTrafDescParam2.access", "read-only");
            this.vccAccRxTrafDescParam2FieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccAccRxTrafDescParam2FieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccAccRxTrafDescParam2Label"), 2);
            if (this.vccAccRxTrafDescParam2FieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 353208);
                this.addRow(this.vccAccRxTrafDescParam2FieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.vccAccRxTrafDescParam2FieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getvccAccRxTrafDescParam2Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccRxTrafDescParam2Field);
            this.validatevccAccRxTrafDescParam2Field();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccAccRxTrafDescParam2Field(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccAccRxTrafDescParam2Field);
                jDMInput.setValue(object);
                this.validatevccAccRxTrafDescParam2Field();
            }
        }

        protected boolean validatevccAccRxTrafDescParam2Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccRxTrafDescParam2Field);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccAccRxTrafDescParam2FieldLabel.setForeground(Color.yellow);
            } else {
                this.vccAccRxTrafDescParam2FieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccAccRxTrafDescParam3Field() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.AccRxTrafDescParam3.access", "read-only");
            this.vccAccRxTrafDescParam3FieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccAccRxTrafDescParam3FieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccAccRxTrafDescParam3Label"), 2);
            if (this.vccAccRxTrafDescParam3FieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 353208);
                this.addRow(this.vccAccRxTrafDescParam3FieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.vccAccRxTrafDescParam3FieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getvccAccRxTrafDescParam3Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccRxTrafDescParam3Field);
            this.validatevccAccRxTrafDescParam3Field();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccAccRxTrafDescParam3Field(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccAccRxTrafDescParam3Field);
                jDMInput.setValue(object);
                this.validatevccAccRxTrafDescParam3Field();
            }
        }

        protected boolean validatevccAccRxTrafDescParam3Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccAccRxTrafDescParam3Field);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccAccRxTrafDescParam3FieldLabel.setForeground(Color.yellow);
            } else {
                this.vccAccRxTrafDescParam3FieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.vccAccTxTrafQoSClassField = this.createvccAccTxTrafQoSClassField();
            this.vccAccTxTrafBestEffortField = this.createvccAccTxTrafBestEffortField();
            this.vccAccTxTrafDescriptorField = this.createvccAccTxTrafDescriptorField();
            this.vccAccTxTrafDescParam1Field = this.createvccAccTxTrafDescParam1Field();
            this.vccAccTxTrafDescParam2Field = this.createvccAccTxTrafDescParam2Field();
            this.vccAccTxTrafDescParam3Field = this.createvccAccTxTrafDescParam3Field();
            this.vccAccRxTrafQoSClassField = this.createvccAccRxTrafQoSClassField();
            this.vccAccRxTrafBestEffortField = this.createvccAccRxTrafBestEffortField();
            this.vccAccRxTrafDescriptorField = this.createvccAccRxTrafDescriptorField();
            this.vccAccRxTrafDescParam1Field = this.createvccAccRxTrafDescParam1Field();
            this.vccAccRxTrafDescParam2Field = this.createvccAccRxTrafDescParam2Field();
            this.vccAccRxTrafDescParam3Field = this.createvccAccRxTrafDescParam3Field();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.vccAccTxTrafQoSClassField)).ignoreValue() && this.vccAccTxTrafQoSClassFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AccTxTrafQoSClass", this.getvccAccTxTrafQoSClassField());
                }
                if (!((JDMInput)((Object)this.vccAccTxTrafBestEffortField)).ignoreValue() && this.vccAccTxTrafBestEffortFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AccTxTrafBestEffort", this.getvccAccTxTrafBestEffortField());
                }
                if (!((JDMInput)((Object)this.vccAccTxTrafDescriptorField)).ignoreValue() && this.vccAccTxTrafDescriptorFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AccTxTrafDescriptor", this.getvccAccTxTrafDescriptorField());
                }
                if (!((JDMInput)((Object)this.vccAccTxTrafDescParam1Field)).ignoreValue() && this.vccAccTxTrafDescParam1FieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AccTxTrafDescParam1", this.getvccAccTxTrafDescParam1Field());
                }
                if (!((JDMInput)((Object)this.vccAccTxTrafDescParam2Field)).ignoreValue() && this.vccAccTxTrafDescParam2FieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AccTxTrafDescParam2", this.getvccAccTxTrafDescParam2Field());
                }
                if (!((JDMInput)((Object)this.vccAccTxTrafDescParam3Field)).ignoreValue() && this.vccAccTxTrafDescParam3FieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AccTxTrafDescParam3", this.getvccAccTxTrafDescParam3Field());
                }
                if (!((JDMInput)((Object)this.vccAccRxTrafQoSClassField)).ignoreValue() && this.vccAccRxTrafQoSClassFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AccRxTrafQoSClass", this.getvccAccRxTrafQoSClassField());
                }
                if (!((JDMInput)((Object)this.vccAccRxTrafBestEffortField)).ignoreValue() && this.vccAccRxTrafBestEffortFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AccRxTrafBestEffort", this.getvccAccRxTrafBestEffortField());
                }
                if (!((JDMInput)((Object)this.vccAccRxTrafDescriptorField)).ignoreValue() && this.vccAccRxTrafDescriptorFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AccRxTrafDescriptor", this.getvccAccRxTrafDescriptorField());
                }
                if (!((JDMInput)((Object)this.vccAccRxTrafDescParam1Field)).ignoreValue() && this.vccAccRxTrafDescParam1FieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AccRxTrafDescParam1", this.getvccAccRxTrafDescParam1Field());
                }
                if (!((JDMInput)((Object)this.vccAccRxTrafDescParam2Field)).ignoreValue() && this.vccAccRxTrafDescParam2FieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AccRxTrafDescParam2", this.getvccAccRxTrafDescParam2Field());
                }
                if (!((JDMInput)((Object)this.vccAccRxTrafDescParam3Field)).ignoreValue() && this.vccAccRxTrafDescParam3FieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.AccRxTrafDescParam3", this.getvccAccRxTrafDescParam3Field());
                    return;
                }
            } else {
                AtmConnectionsBasePanel.this.errorsFound = true;
            }
        }

        public void reset() {
            AtmConnectionsBasePanel.this.displayMsg(AtmConnectionsBasePanel.getNLSString("accessDataMsg"));
            try {
                this.setvccAccTxTrafQoSClassField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccTxTrafQoSClass", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccAccTxTrafBestEffortField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccTxTrafBestEffort", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccAccTxTrafDescriptorField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccTxTrafDescriptor", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccAccTxTrafDescParam1Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccTxTrafDescParam1", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccAccTxTrafDescParam2Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccTxTrafDescParam2", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccAccTxTrafDescParam3Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccTxTrafDescParam3", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccAccRxTrafQoSClassField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccRxTrafQoSClass", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccAccRxTrafBestEffortField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccRxTrafBestEffort", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccAccRxTrafDescriptorField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccRxTrafDescriptor", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccAccRxTrafDescParam1Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccRxTrafDescParam1", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccAccRxTrafDescParam2Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccRxTrafDescParam2", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccAccRxTrafDescParam3Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccRxTrafDescParam3", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            }
            catch (NullPointerException nullPointerException) {}
            AtmConnectionsBasePanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.setvccAccTxTrafQoSClassField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccTxTrafQoSClass", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccAccTxTrafBestEffortField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccTxTrafBestEffort", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccAccTxTrafDescriptorField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccTxTrafDescriptor", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccAccTxTrafDescParam1Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccTxTrafDescParam1", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccAccTxTrafDescParam2Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccTxTrafDescParam2", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccAccTxTrafDescParam3Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccTxTrafDescParam3", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccAccRxTrafQoSClassField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccRxTrafQoSClass", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccAccRxTrafBestEffortField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccRxTrafBestEffort", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccAccRxTrafDescriptorField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccRxTrafDescriptor", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccAccRxTrafDescParam1Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccRxTrafDescParam1", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccAccRxTrafDescParam2Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccRxTrafDescParam2", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccAccRxTrafDescParam3Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.AccRxTrafDescParam3", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.doLayout();
        }

        public boolean validateSection() {
            if (!((JDMInput)((Object)this.vccAccRxTrafBestEffortField)).ignoreValue() && !this.validatevccAccRxTrafBestEffortField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.vccAccTxTrafBestEffortField)).ignoreValue() && !this.validatevccAccTxTrafBestEffortField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.vccAccRxTrafDescriptorField)).ignoreValue() && !this.validatevccAccRxTrafDescriptorField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.vccAccTxTrafDescriptorField)).ignoreValue() && !this.validatevccAccTxTrafDescriptorField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.vccAccRxTrafDescParam1Field)).ignoreValue() && !this.validatevccAccRxTrafDescParam1Field()) {
                return false;
            }
            return ((JDMInput)((Object)this.vccAccTxTrafDescParam1Field)).ignoreValue() || this.validatevccAccTxTrafDescParam1Field();
        }
    }

    public class AtmVccActQosSection
    extends PropertySection {
        ModelInfo chunk;
        Component vccActTxTrafQoSClassField;
        Component vccActTxTrafBestEffortField;
        Component vccActTxTrafDescriptorField;
        Component vccActTxTrafDescParam1Field;
        Component vccActTxTrafDescParam2Field;
        Component vccActTxTrafDescParam3Field;
        Component vccActRxTrafQoSClassField;
        Component vccActRxTrafBestEffortField;
        Component vccActRxTrafDescriptorField;
        Component vccActRxTrafDescParam1Field;
        Component vccActRxTrafDescParam2Field;
        Component vccActRxTrafDescParam3Field;
        Label vccActTxTrafQoSClassFieldLabel;
        Label vccActTxTrafBestEffortFieldLabel;
        Label vccActTxTrafDescriptorFieldLabel;
        Label vccActTxTrafDescParam1FieldLabel;
        Label vccActTxTrafDescParam2FieldLabel;
        Label vccActTxTrafDescParam3FieldLabel;
        Label vccActRxTrafQoSClassFieldLabel;
        Label vccActRxTrafBestEffortFieldLabel;
        Label vccActRxTrafDescriptorFieldLabel;
        Label vccActRxTrafDescParam1FieldLabel;
        Label vccActRxTrafDescParam2FieldLabel;
        Label vccActRxTrafDescParam3FieldLabel;
        boolean vccActTxTrafQoSClassFieldWritable = false;
        boolean vccActTxTrafBestEffortFieldWritable = false;
        boolean vccActTxTrafDescriptorFieldWritable = false;
        boolean vccActTxTrafDescParam1FieldWritable = false;
        boolean vccActTxTrafDescParam2FieldWritable = false;
        boolean vccActTxTrafDescParam3FieldWritable = false;
        boolean vccActRxTrafQoSClassFieldWritable = false;
        boolean vccActRxTrafBestEffortFieldWritable = false;
        boolean vccActRxTrafDescriptorFieldWritable = false;
        boolean vccActRxTrafDescParam1FieldWritable = false;
        boolean vccActRxTrafDescParam2FieldWritable = false;
        boolean vccActRxTrafDescParam3FieldWritable = false;

        public AtmVccActQosSection() {
            AtmConnectionsBasePanel.this = AtmConnectionsBasePanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createvccActTxTrafQoSClassField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ActTxTrafQoSClass.access", "read-only");
            this.vccActTxTrafQoSClassFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccActTxTrafQoSClassFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccActTxTrafQoSClassLabel"), 2);
            if (this.vccActTxTrafQoSClassFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxConnectionModel.AtmxConnDetails.ActTxTrafQoSClassEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ActTxTrafQoSClassEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
                this.addRow(this.vccActTxTrafQoSClassFieldLabel, (Component)singleChoiceInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxConnectionModel.AtmxConnDetails.ActTxTrafQoSClassEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ActTxTrafQoSClassEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
            this.addRow(this.vccActTxTrafQoSClassFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getvccActTxTrafQoSClassField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActTxTrafQoSClassField);
            this.validatevccActTxTrafQoSClassField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccActTxTrafQoSClassField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccActTxTrafQoSClassField);
                jDMInput.setValue(object);
                this.validatevccActTxTrafQoSClassField();
            }
        }

        protected boolean validatevccActTxTrafQoSClassField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActTxTrafQoSClassField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccActTxTrafQoSClassFieldLabel.setForeground(Color.yellow);
            } else {
                this.vccActTxTrafQoSClassFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccActTxTrafBestEffortField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ActTxTrafBestEffort.access", "read-only");
            this.vccActTxTrafBestEffortFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccActTxTrafBestEffortFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccActTxTrafBestEffortLabel"), 2);
            if (this.vccActTxTrafBestEffortFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxConnectionModel.AtmxConnDetails.ActTxTrafBestEffortEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ActTxTrafBestEffortEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
                this.addRow(this.vccActTxTrafBestEffortFieldLabel, (Component)singleChoiceInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxConnectionModel.AtmxConnDetails.ActTxTrafBestEffortEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ActTxTrafBestEffortEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
            this.addRow(this.vccActTxTrafBestEffortFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getvccActTxTrafBestEffortField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActTxTrafBestEffortField);
            this.validatevccActTxTrafBestEffortField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccActTxTrafBestEffortField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccActTxTrafBestEffortField);
                jDMInput.setValue(object);
                this.validatevccActTxTrafBestEffortField();
            }
        }

        protected boolean validatevccActTxTrafBestEffortField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActTxTrafBestEffortField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccActTxTrafBestEffortFieldLabel.setForeground(Color.yellow);
            } else {
                this.vccActTxTrafBestEffortFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccActTxTrafDescriptorField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ActTxTrafDescriptor.access", "read-only");
            this.vccActTxTrafDescriptorFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccActTxTrafDescriptorFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccActTxTrafDescriptorLabel"), 2);
            if (this.vccActTxTrafDescriptorFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxConnectionModel.AtmxConnDetails.ActTxTrafDescriptorEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ActTxTrafDescriptorEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
                this.addRow(this.vccActTxTrafDescriptorFieldLabel, (Component)singleChoiceInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxConnectionModel.AtmxConnDetails.ActTxTrafDescriptorEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ActTxTrafDescriptorEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
            this.addRow(this.vccActTxTrafDescriptorFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getvccActTxTrafDescriptorField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActTxTrafDescriptorField);
            this.validatevccActTxTrafDescriptorField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccActTxTrafDescriptorField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccActTxTrafDescriptorField);
                jDMInput.setValue(object);
                this.validatevccActTxTrafDescriptorField();
            }
        }

        protected boolean validatevccActTxTrafDescriptorField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActTxTrafDescriptorField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccActTxTrafDescriptorFieldLabel.setForeground(Color.yellow);
            } else {
                this.vccActTxTrafDescriptorFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccActTxTrafDescParam1Field() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ActTxTrafDescParam1.access", "read-only");
            this.vccActTxTrafDescParam1FieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccActTxTrafDescParam1FieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccActTxTrafDescParam1Label"), 2);
            if (this.vccActTxTrafDescParam1FieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 353208);
                this.addRow(this.vccActTxTrafDescParam1FieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.vccActTxTrafDescParam1FieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getvccActTxTrafDescParam1Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActTxTrafDescParam1Field);
            this.validatevccActTxTrafDescParam1Field();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccActTxTrafDescParam1Field(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccActTxTrafDescParam1Field);
                jDMInput.setValue(object);
                this.validatevccActTxTrafDescParam1Field();
            }
        }

        protected boolean validatevccActTxTrafDescParam1Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActTxTrafDescParam1Field);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccActTxTrafDescParam1FieldLabel.setForeground(Color.yellow);
            } else {
                this.vccActTxTrafDescParam1FieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccActTxTrafDescParam2Field() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ActTxTrafDescParam2.access", "read-only");
            this.vccActTxTrafDescParam2FieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccActTxTrafDescParam2FieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccActTxTrafDescParam2Label"), 2);
            if (this.vccActTxTrafDescParam2FieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 353208);
                this.addRow(this.vccActTxTrafDescParam2FieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.vccActTxTrafDescParam2FieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getvccActTxTrafDescParam2Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActTxTrafDescParam2Field);
            this.validatevccActTxTrafDescParam2Field();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccActTxTrafDescParam2Field(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccActTxTrafDescParam2Field);
                jDMInput.setValue(object);
                this.validatevccActTxTrafDescParam2Field();
            }
        }

        protected boolean validatevccActTxTrafDescParam2Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActTxTrafDescParam2Field);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccActTxTrafDescParam2FieldLabel.setForeground(Color.yellow);
            } else {
                this.vccActTxTrafDescParam2FieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccActTxTrafDescParam3Field() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ActTxTrafDescParam3.access", "read-only");
            this.vccActTxTrafDescParam3FieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccActTxTrafDescParam3FieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccActTxTrafDescParam3Label"), 2);
            if (this.vccActTxTrafDescParam3FieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 353208);
                this.addRow(this.vccActTxTrafDescParam3FieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.vccActTxTrafDescParam3FieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getvccActTxTrafDescParam3Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActTxTrafDescParam3Field);
            this.validatevccActTxTrafDescParam3Field();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccActTxTrafDescParam3Field(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccActTxTrafDescParam3Field);
                jDMInput.setValue(object);
                this.validatevccActTxTrafDescParam3Field();
            }
        }

        protected boolean validatevccActTxTrafDescParam3Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActTxTrafDescParam3Field);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccActTxTrafDescParam3FieldLabel.setForeground(Color.yellow);
            } else {
                this.vccActTxTrafDescParam3FieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccActRxTrafQoSClassField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ActRxTrafQoSClass.access", "read-only");
            this.vccActRxTrafQoSClassFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccActRxTrafQoSClassFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccActRxTrafQoSClassLabel"), 2);
            if (this.vccActRxTrafQoSClassFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxConnectionModel.AtmxConnDetails.ActRxTrafQoSClassEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ActRxTrafQoSClassEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
                this.addRow(this.vccActRxTrafQoSClassFieldLabel, (Component)singleChoiceInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxConnectionModel.AtmxConnDetails.ActRxTrafQoSClassEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ActRxTrafQoSClassEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
            this.addRow(this.vccActRxTrafQoSClassFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getvccActRxTrafQoSClassField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActRxTrafQoSClassField);
            this.validatevccActRxTrafQoSClassField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccActRxTrafQoSClassField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccActRxTrafQoSClassField);
                jDMInput.setValue(object);
                this.validatevccActRxTrafQoSClassField();
            }
        }

        protected boolean validatevccActRxTrafQoSClassField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActRxTrafQoSClassField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccActRxTrafQoSClassFieldLabel.setForeground(Color.yellow);
            } else {
                this.vccActRxTrafQoSClassFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccActRxTrafBestEffortField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ActRxTrafBestEffort.access", "read-only");
            this.vccActRxTrafBestEffortFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccActRxTrafBestEffortFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccActRxTrafBestEffortLabel"), 2);
            if (this.vccActRxTrafBestEffortFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxConnectionModel.AtmxConnDetails.ActRxTrafBestEffortEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ActRxTrafBestEffortEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
                this.addRow(this.vccActRxTrafBestEffortFieldLabel, (Component)singleChoiceInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxConnectionModel.AtmxConnDetails.ActRxTrafBestEffortEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ActRxTrafBestEffortEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
            this.addRow(this.vccActRxTrafBestEffortFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getvccActRxTrafBestEffortField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActRxTrafBestEffortField);
            this.validatevccActRxTrafBestEffortField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccActRxTrafBestEffortField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccActRxTrafBestEffortField);
                jDMInput.setValue(object);
                this.validatevccActRxTrafBestEffortField();
            }
        }

        protected boolean validatevccActRxTrafBestEffortField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActRxTrafBestEffortField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccActRxTrafBestEffortFieldLabel.setForeground(Color.yellow);
            } else {
                this.vccActRxTrafBestEffortFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccActRxTrafDescriptorField() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ActRxTrafDescriptor.access", "read-only");
            this.vccActRxTrafDescriptorFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccActRxTrafDescriptorFieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccActRxTrafDescriptorLabel"), 2);
            if (this.vccActRxTrafDescriptorFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmxConnectionModel.AtmxConnDetails.ActRxTrafDescriptorEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ActRxTrafDescriptorEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
                this.addRow(this.vccActRxTrafDescriptorFieldLabel, (Component)singleChoiceInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmxConnectionModel.AtmxConnDetails.ActRxTrafDescriptorEnum.symbolicValues, AtmxConnectionModel.AtmxConnDetails.ActRxTrafDescriptorEnum.numericValues, AtmConnectionsBasePanel.getEnumStrings());
            this.addRow(this.vccActRxTrafDescriptorFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getvccActRxTrafDescriptorField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActRxTrafDescriptorField);
            this.validatevccActRxTrafDescriptorField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccActRxTrafDescriptorField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccActRxTrafDescriptorField);
                jDMInput.setValue(object);
                this.validatevccActRxTrafDescriptorField();
            }
        }

        protected boolean validatevccActRxTrafDescriptorField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActRxTrafDescriptorField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccActRxTrafDescriptorFieldLabel.setForeground(Color.yellow);
            } else {
                this.vccActRxTrafDescriptorFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccActRxTrafDescParam1Field() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ActRxTrafDescParam1.access", "read-only");
            this.vccActRxTrafDescParam1FieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccActRxTrafDescParam1FieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccActRxTrafDescParam1Label"), 2);
            if (this.vccActRxTrafDescParam1FieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 353208);
                this.addRow(this.vccActRxTrafDescParam1FieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.vccActRxTrafDescParam1FieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getvccActRxTrafDescParam1Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActRxTrafDescParam1Field);
            this.validatevccActRxTrafDescParam1Field();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccActRxTrafDescParam1Field(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccActRxTrafDescParam1Field);
                jDMInput.setValue(object);
                this.validatevccActRxTrafDescParam1Field();
            }
        }

        protected boolean validatevccActRxTrafDescParam1Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActRxTrafDescParam1Field);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccActRxTrafDescParam1FieldLabel.setForeground(Color.yellow);
            } else {
                this.vccActRxTrafDescParam1FieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccActRxTrafDescParam2Field() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ActRxTrafDescParam2.access", "read-only");
            this.vccActRxTrafDescParam2FieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccActRxTrafDescParam2FieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccActRxTrafDescParam2Label"), 2);
            if (this.vccActRxTrafDescParam2FieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 353208);
                this.addRow(this.vccActRxTrafDescParam2FieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.vccActRxTrafDescParam2FieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getvccActRxTrafDescParam2Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActRxTrafDescParam2Field);
            this.validatevccActRxTrafDescParam2Field();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccActRxTrafDescParam2Field(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccActRxTrafDescParam2Field);
                jDMInput.setValue(object);
                this.validatevccActRxTrafDescParam2Field();
            }
        }

        protected boolean validatevccActRxTrafDescParam2Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActRxTrafDescParam2Field);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccActRxTrafDescParam2FieldLabel.setForeground(Color.yellow);
            } else {
                this.vccActRxTrafDescParam2FieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvccActRxTrafDescParam3Field() {
            String string = AtmConnectionsBasePanel.this.getOverride("ibm.nways.jdm8273.model.AtmxConnection.AtmxConnDetails.ActRxTrafDescParam3.access", "read-only");
            this.vccActRxTrafDescParam3FieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vccActRxTrafDescParam3FieldLabel = new Label(AtmConnectionsBasePanel.getNLSString("vccActRxTrafDescParam3Label"), 2);
            if (this.vccActRxTrafDescParam3FieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 353208);
                this.addRow(this.vccActRxTrafDescParam3FieldLabel, (Component)numericInput);
                AtmConnectionsBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.vccActRxTrafDescParam3FieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getvccActRxTrafDescParam3Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActRxTrafDescParam3Field);
            this.validatevccActRxTrafDescParam3Field();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvccActRxTrafDescParam3Field(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vccActRxTrafDescParam3Field);
                jDMInput.setValue(object);
                this.validatevccActRxTrafDescParam3Field();
            }
        }

        protected boolean validatevccActRxTrafDescParam3Field() {
            JDMInput jDMInput = (JDMInput)((Object)this.vccActRxTrafDescParam3Field);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vccActRxTrafDescParam3FieldLabel.setForeground(Color.yellow);
            } else {
                this.vccActRxTrafDescParam3FieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.vccActTxTrafQoSClassField = this.createvccActTxTrafQoSClassField();
            this.vccActTxTrafBestEffortField = this.createvccActTxTrafBestEffortField();
            this.vccActTxTrafDescriptorField = this.createvccActTxTrafDescriptorField();
            this.vccActTxTrafDescParam1Field = this.createvccActTxTrafDescParam1Field();
            this.vccActTxTrafDescParam2Field = this.createvccActTxTrafDescParam2Field();
            this.vccActTxTrafDescParam3Field = this.createvccActTxTrafDescParam3Field();
            this.vccActRxTrafQoSClassField = this.createvccActRxTrafQoSClassField();
            this.vccActRxTrafBestEffortField = this.createvccActRxTrafBestEffortField();
            this.vccActRxTrafDescriptorField = this.createvccActRxTrafDescriptorField();
            this.vccActRxTrafDescParam1Field = this.createvccActRxTrafDescParam1Field();
            this.vccActRxTrafDescParam2Field = this.createvccActRxTrafDescParam2Field();
            this.vccActRxTrafDescParam3Field = this.createvccActRxTrafDescParam3Field();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.vccActTxTrafQoSClassField)).ignoreValue() && this.vccActTxTrafQoSClassFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ActTxTrafQoSClass", this.getvccActTxTrafQoSClassField());
                }
                if (!((JDMInput)((Object)this.vccActTxTrafBestEffortField)).ignoreValue() && this.vccActTxTrafBestEffortFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ActTxTrafBestEffort", this.getvccActTxTrafBestEffortField());
                }
                if (!((JDMInput)((Object)this.vccActTxTrafDescriptorField)).ignoreValue() && this.vccActTxTrafDescriptorFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ActTxTrafDescriptor", this.getvccActTxTrafDescriptorField());
                }
                if (!((JDMInput)((Object)this.vccActTxTrafDescParam1Field)).ignoreValue() && this.vccActTxTrafDescParam1FieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ActTxTrafDescParam1", this.getvccActTxTrafDescParam1Field());
                }
                if (!((JDMInput)((Object)this.vccActTxTrafDescParam2Field)).ignoreValue() && this.vccActTxTrafDescParam2FieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ActTxTrafDescParam2", this.getvccActTxTrafDescParam2Field());
                }
                if (!((JDMInput)((Object)this.vccActTxTrafDescParam3Field)).ignoreValue() && this.vccActTxTrafDescParam3FieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ActTxTrafDescParam3", this.getvccActTxTrafDescParam3Field());
                }
                if (!((JDMInput)((Object)this.vccActRxTrafQoSClassField)).ignoreValue() && this.vccActRxTrafQoSClassFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ActRxTrafQoSClass", this.getvccActRxTrafQoSClassField());
                }
                if (!((JDMInput)((Object)this.vccActRxTrafBestEffortField)).ignoreValue() && this.vccActRxTrafBestEffortFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ActRxTrafBestEffort", this.getvccActRxTrafBestEffortField());
                }
                if (!((JDMInput)((Object)this.vccActRxTrafDescriptorField)).ignoreValue() && this.vccActRxTrafDescriptorFieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ActRxTrafDescriptor", this.getvccActRxTrafDescriptorField());
                }
                if (!((JDMInput)((Object)this.vccActRxTrafDescParam1Field)).ignoreValue() && this.vccActRxTrafDescParam1FieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ActRxTrafDescParam1", this.getvccActRxTrafDescParam1Field());
                }
                if (!((JDMInput)((Object)this.vccActRxTrafDescParam2Field)).ignoreValue() && this.vccActRxTrafDescParam2FieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ActRxTrafDescParam2", this.getvccActRxTrafDescParam2Field());
                }
                if (!((JDMInput)((Object)this.vccActRxTrafDescParam3Field)).ignoreValue() && this.vccActRxTrafDescParam3FieldWritable) {
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.add("AtmxConnDetails.ActRxTrafDescParam3", this.getvccActRxTrafDescParam3Field());
                    return;
                }
            } else {
                AtmConnectionsBasePanel.this.errorsFound = true;
            }
        }

        public void reset() {
            AtmConnectionsBasePanel.this.displayMsg(AtmConnectionsBasePanel.getNLSString("accessDataMsg"));
            try {
                this.setvccActTxTrafQoSClassField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActTxTrafQoSClass", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccActTxTrafBestEffortField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActTxTrafBestEffort", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccActTxTrafDescriptorField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActTxTrafDescriptor", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccActTxTrafDescParam1Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActTxTrafDescParam1", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccActTxTrafDescParam2Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActTxTrafDescParam2", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccActTxTrafDescParam3Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActTxTrafDescParam3", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccActRxTrafQoSClassField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActRxTrafQoSClass", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccActRxTrafBestEffortField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActRxTrafBestEffort", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccActRxTrafDescriptorField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActRxTrafDescriptor", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccActRxTrafDescParam1Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActRxTrafDescParam1", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccActRxTrafDescParam2Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActRxTrafDescParam2", AtmConnectionsBasePanel.this.AtmVccTableIndex));
                this.setvccActRxTrafDescParam3Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActRxTrafDescParam3", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            }
            catch (NullPointerException nullPointerException) {}
            AtmConnectionsBasePanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.setvccActTxTrafQoSClassField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActTxTrafQoSClass", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccActTxTrafBestEffortField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActTxTrafBestEffort", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccActTxTrafDescriptorField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActTxTrafDescriptor", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccActTxTrafDescParam1Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActTxTrafDescParam1", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccActTxTrafDescParam2Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActTxTrafDescParam2", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccActTxTrafDescParam3Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActTxTrafDescParam3", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccActRxTrafQoSClassField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActRxTrafQoSClass", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccActRxTrafBestEffortField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActRxTrafBestEffort", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccActRxTrafDescriptorField(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActRxTrafDescriptor", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccActRxTrafDescParam1Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActRxTrafDescParam1", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccActRxTrafDescParam2Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActRxTrafDescParam2", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.setvccActRxTrafDescParam3Field(AtmConnectionsBasePanel.this.AtmVccTableData.getValueAt("AtmxConnDetails.ActRxTrafDescParam3", AtmConnectionsBasePanel.this.AtmVccTableIndex));
            this.doLayout();
        }

        public boolean validateSection() {
            return true;
        }
    }

    public class AtmVccTable
    extends Table {
        public ModelInfo setRow() {
            try {
                AtmConnectionsBasePanel.this.displayMsg(AtmConnectionsBasePanel.getNLSString("startSendMsg"));
                AtmConnectionsBasePanel.this.AtmxConnDetailsInfo = AtmConnectionsBasePanel.this.AtmxConnection_model.setInfo("AtmxConnDetails", AtmConnectionsBasePanel.this.AtmxConnDetailsInfo);
                AtmConnectionsBasePanel.this.displayMsg(AtmConnectionsBasePanel.getNLSString("endSendMsg"));
                if (AtmConnectionsBasePanel.this.AtmxConnDetailsInfo != null) {
                    Enumeration enumeration = AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.getItemIds();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Serializable serializable = AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.get(string);
                        AtmConnectionsBasePanel.this.AtmVccTableInfo.add(string, serializable);
                    }
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return AtmConnectionsBasePanel.this.AtmVccTableInfo;
        }

        public ModelInfo getRow(ModelInfo modelInfo) {
            try {
                while (true) {
                    AtmConnectionsBasePanel.this.AtmVccTableInfo = null;
                    AtmConnectionsBasePanel.this.displayMsg(AtmConnectionsBasePanel.getNLSString("startRow"));
                    AtmConnectionsBasePanel.this.AtmxConnDetailsInfo = AtmConnectionsBasePanel.this.AtmxConnection_model.getNextInfo("AtmxConnDetails", "default", modelInfo);
                    AtmConnectionsBasePanel.this.displayMsg(AtmConnectionsBasePanel.getNLSString("endRow"));
                    if (AtmConnectionsBasePanel.this.AtmxConnDetailsInfo != null) {
                        AtmConnectionsBasePanel.this.AtmVccTableInfo = new ModelInfo();
                        if (AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.isBeingMonitored()) {
                            AtmConnectionsBasePanel.this.AtmVccTableInfo.flagAsMonitored();
                        }
                        Enumeration enumeration = AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.getItemIds();
                        while (enumeration.hasMoreElements()) {
                            String string = (String)enumeration.nextElement();
                            Serializable serializable = AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.get(string);
                            AtmConnectionsBasePanel.this.AtmVccTableInfo.add(string, serializable);
                        }
                    }
                    if (AtmConnectionsBasePanel.this.AtmVccTableInfo != null && !this.validRow(AtmConnectionsBasePanel.this.AtmVccTableInfo)) {
                        modelInfo = AtmConnectionsBasePanel.this.AtmVccTableInfo;
                        continue;
                    }
                    break;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return AtmConnectionsBasePanel.this.AtmVccTableInfo;
        }

        public ModelInfo getSpecificRow(ModelInfo modelInfo) {
            AtmConnectionsBasePanel.this.AtmVccTableInfo = null;
            try {
                AtmConnectionsBasePanel.this.displayMsg(AtmConnectionsBasePanel.getNLSString("startRow"));
                AtmConnectionsBasePanel.this.AtmxConnDetailsInfo = AtmConnectionsBasePanel.this.AtmxConnection_model.getInfo("AtmxConnDetails", "default", modelInfo);
                AtmConnectionsBasePanel.this.displayMsg(AtmConnectionsBasePanel.getNLSString("endRow"));
                if (AtmConnectionsBasePanel.this.AtmxConnDetailsInfo != null) {
                    AtmConnectionsBasePanel.this.AtmVccTableInfo = new ModelInfo();
                    if (AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.isBeingMonitored()) {
                        AtmConnectionsBasePanel.this.AtmVccTableInfo.flagAsMonitored();
                    }
                    Enumeration enumeration = AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.getItemIds();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Serializable serializable = AtmConnectionsBasePanel.this.AtmxConnDetailsInfo.get(string);
                        AtmConnectionsBasePanel.this.AtmVccTableInfo.add(string, serializable);
                    }
                }
                if (AtmConnectionsBasePanel.this.AtmVccTableInfo != null && !this.validRow(AtmConnectionsBasePanel.this.AtmVccTableInfo)) {
                    AtmConnectionsBasePanel.this.AtmVccTableInfo = this.getRow(AtmConnectionsBasePanel.this.AtmVccTableInfo);
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return AtmConnectionsBasePanel.this.AtmVccTableInfo;
        }

        public boolean validRow(ModelInfo modelInfo) {
            return true;
        }

        public void setMonitoring(ModelInfo[] modelInfoArray, boolean bl) {
            try {
                if (AtmConnectionsBasePanel.this.AtmVccTableStatus != null) {
                    if (modelInfoArray != null) {
                        if (bl) {
                            AtmConnectionsBasePanel.this.AtmVccTableStatus.monitor(modelInfoArray);
                            return;
                        }
                        AtmConnectionsBasePanel.this.AtmVccTableStatus.doNotMonitor(modelInfoArray);
                        return;
                    }
                    if (bl) {
                        AtmConnectionsBasePanel.this.AtmVccTableStatus.setMaxRows(Integer.MAX_VALUE);
                        return;
                    }
                    AtmConnectionsBasePanel.this.AtmVccTableStatus.setMaxRows(0);
                    return;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
        }

        public String translateEnum(String string, int n) {
            String string2 = String.valueOf(n);
            try {
                if (string.equals("AtmxConnDetails.AtmxVccOperStatus")) {
                    string2 = enumStrings.getString(AtmxConnectionModel.AtmxConnDetails.AtmxVccOperStatusEnum.numericToSymbolic(n));
                }
            }
            catch (MissingResourceException missingResourceException) {}
            try {
                if (string.equals("AtmxConnDetails.AtmxVccCircuitType")) {
                    string2 = enumStrings.getString(AtmxConnectionModel.AtmxConnDetails.AtmxVccCircuitTypeEnum.numericToSymbolic(n));
                }
            }
            catch (MissingResourceException missingResourceException) {}
            return string2;
        }

        public AtmVccTable() {
            AtmConnectionsBasePanel.this = AtmConnectionsBasePanel.this;
        }
    }
}

